package gov.va.med.esr.common.batchprocess;
import java.util.List;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;


/**
 * Contains logic to Purge Inactive Completed Reports.
 *
 * @author Venky Kulllampalle
 * @version 1.0
 *
 * Copyright  2006 VHA. All rights reserved
 */
public class PurgeInactiveReportsProcess extends AbstractReportProcess
{
   
    
    /**
     * This method uses System Parameter Service to retrieve Purge Archived Reports Parameter.
     * Calls Standard Report Service to purge completed reports.
     * Updates process statistics.
     * @param context
     * @param acquiredData
     * 
     */
    public void processData(DataProcessExecutionContext context, List acquiredData)
    {
        try
        {  
            SystemParameter sysParameter= getSystemParameterService().getByName(SystemParameter.PURGE_ARCHIVE_REPORTS_PARAMETER);
            if(sysParameter!=null)
            {  
                int noOfRecords=this.getReportService().purgeCompletedReports(getUpdateQueryString(),getAuditInfo(), sysParameter);
                context.getProcessStatistics().setNumberOfTotalRecords(
                        context.getProcessStatistics().getNumberOfTotalRecords()                            
                                + noOfRecords);
                context.getProcessStatistics().setNumberOfSuccessfulRecords(
                        context.getProcessStatistics().getNumberOfSuccessfulRecords()                            
                                + noOfRecords);
            }
      } catch ( Exception e )
    {           
        String errorMessage = "Error while executing Purging Completed Reports batch process :"
                + " Reason: " + e.getMessage();
            context.getExceptionData().add(errorMessage);
            if (logger.isWarnEnabled())
                logger.warn(errorMessage, e);
        }
  }
   
}