package gov.va.med.esr.common.batchprocess;


import java.util.List;

import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;

/**
 * 
 * @author Wayne Sheu
 *
 */
public class ProcessWaittimeFromCDW extends AbstractDataQueryIncrementalProcess {

	@Override
	protected void processData(DataQueryProcessExecutionContext context, List acquiredData) {
		
        if(logger.isDebugEnabled())
            logger.debug(getProcessName() + "Process Waittime from CDW: Query increment result Size="
            		+ (acquiredData == null ? 0 : acquiredData.size()));        
        if (acquiredData == null)
            return;
        
        // Add check for isInterrupted so don't have to wait for entire batch to finish
        for (int i = 0; i < acquiredData.size() && !isInterrupted(context); i++) {
            Object[] row = (Object[]) acquiredData.get(i);

            // TODO: Use the <sql-query>
            //BigDecimal primaryPersonId = (BigDecimal) row[0]; 
    
            if(logger.isDebugEnabled())
            	logger.debug("Process Waittime from CDW record # " + (i+1) + " with TBD-literal msg ="); 
            			            
            
            try {
            	
            	// TODO: trigger JRules 
            	// VC Letter
            	// Update health Plan
		            
	            context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
	            
            } catch (Exception ex) {
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                String errMsg = "Error while executing " + getProcessName() + " for TDB-literal msg=";
                context.getExceptionData().add(errMsg+ " Reason: "+ ex.getMessage());
                if(logger.isWarnEnabled())
                    logger.warn(errMsg + " Reason: ", ex);
            }
            
            // Update statistics more frequently than once per batch (default size 500)
            if(context.getProcessStatistics().isTotalNumberMod(DEFAULT_JOB_RESULT_UPDATE_INTERVAL))
                this.updateJobResult(context);
        }
        
        if(logger.isDebugEnabled()) {
            logger.debug(getProcessName() + ": Processing of current batch complete.");
            logger.debug(getProcessName() + ": Successful records count = "+context.getProcessStatistics().getNumberOfSuccessfulRecords());
            logger.debug(getProcessName() + ": Failure records count ="+context.getProcessStatistics().getNumberOfErrorRecords());
        }

	}
	
	// TBD: Will not override AbstractDataQueryProcess::executeQuery() 
	// because we will use <sql-query> instead of stored procedure. 
	// If we use stores procedure, we need to override executeQuery() here
	//protected List executeQuery(DataQueryProcessExecutionContext context) throws Exception {}    

}
