package gov.va.med.esr.common.batchprocess;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.model.registry.RegistryTraitDetail;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.util.StringUtils;

/**
 * Parses a POW input data record and creates a Registry object from it.
 * 
 * @author Rajiv Patnaik Created on Apr 12, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class PrisonerOfWarRegistryFileData extends LoadRegistryFileData
{ 
	/**
	 * 
	 */
	private static final long serialVersionUID = -4989353564824931925L;

	private static Class[] AUTO_REGISTER_CLASSES = new Class[] {PrisonerOfWar.class, POWEpisode.class};
	
	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClasses(AUTO_REGISTER_CLASSES);
	}
	
    //Field names used for the data records
    private static final String DOCUMENT_TYPE = "documentType";

    private static final String POW_INDICATOR = "powIndicator";

    private static final String MILITARY_SERVICE_NUMBER = "militaryServiceNumber";

    private static final String NUMBER_OF_DAYS_IN_CAPTIVITY = "numberOfDaysInCaptivity";

    private static final String DATE_ENTERED = "dateEntered";

    private static final String DATA_SOURCE = "dataSource";

    private static final String CAMP_LOCATION = "campLocation";

    private static final String CONFINEMENT_LOCATION = "confinementLocation";

    private static final String RELEASE_DATE = "releaseDate";

    private static final String CAPTURE_DATE = "captureDate";

    private static final String DEATH_DATE = "deathDate";
    

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);

    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String,
     *      com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow,
            ClassMapping classMapping) throws Exception
    {
        PrisonerOfWar prisonerOfWar = new PrisonerOfWar();
        POWEpisode episode = new POWEpisode();
        RegistryTrait trait = new RegistryTrait();
        RegistryTraitDetail traitDetail = new RegistryTraitDetail();

        int i = 0;
        trait.setLastName(StringUtils.stripToNull(parsedRow.getString(i++)));
        trait.setFirstName(StringUtils.stripToNull(parsedRow.getString(i++)));
        trait.setMiddleName(StringUtils.stripToNull(parsedRow.getString(i++)));
        trait.setPrefix(StringUtils.stripToNull(parsedRow.getString(i++)));
        trait.setSuffix(StringUtils.stripToNull(parsedRow.getString(i++)));
        trait.setEducationalDegree(StringUtils.stripToNull(parsedRow.getString(i++)));
        // CodeCR 7265: SSN values don't include leading 0s, left pad to put them back in
        trait.setSsn(buildSsnValue(parsedRow.getString(i++)));
        prisonerOfWar.setIcn(StringUtils.stripToNull(parsedRow.getString(i++)));
        RawFileDataContainerUtils.setConvertedField(trait, DEATH_DATE,
                parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(episode, CAPTURE_DATE,
                parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(episode, RELEASE_DATE,
                parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(episode,
                CONFINEMENT_LOCATION, parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(episode, CAMP_LOCATION,
                parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(episode, DATA_SOURCE,
                parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(episode, DATE_ENTERED,
                parsedRow.getString(i++));
        //Do not uses Bean Utils which converts non-numeric values to 0 instead of throwing a NumberFormatException
        episode.setNumberOfDaysInCaptivity(buildIntegerValue(parsedRow.getString(i++)));
        RawFileDataContainerUtils.setConvertedField(traitDetail, 
                MILITARY_SERVICE_NUMBER, parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(prisonerOfWar,
                POW_INDICATOR, parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(episode, DOCUMENT_TYPE,
                parsedRow.getString(i++));
        RawFileDataContainerUtils.setConvertedField(trait, REGISTRY_TYPE,
                RegistryType.CODE_POW_REGISTRY.getCode());

        trait.addRegistryTraitDetail(traitDetail);
        prisonerOfWar.setRegistryTrait(trait);
        prisonerOfWar.addEpisode(episode);

        setRegistry(prisonerOfWar);

    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception
    {
        //no op as this class is used only for parsing from an input record
        return null;
    }

	/* (non-Javadoc)
	 * @see gov.va.med.fw.io.RawFileDataContainer#getClassesForAutoRegisterConverters()
	 */
	public Class[] getClassesForAutoRegisterConverters() {
		return AUTO_REGISTER_CLASSES;
	}

}