package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.TeamPurpose;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.HealthCareProvider;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.PatientProviderAssignmentLite;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;

import java.util.Date;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

public class PCMMImportData extends AbstractRawFileDataContainer {
	/**
	 * 
	 */
	private static final long serialVersionUID = 9174638743801708112L;

	private String transactionType;
	private String patientIEN;
	private String patientSta3n;
	private VAFacility facility;
	private Long teamId;	
	private TeamPurpose teamPurpose;	
	private String teamName;	
	private String practitionerIEN;	
	private String practitionerSta3n;	
	private String providerLastName;	
	private String providerFirstName;	
	private String providerMiddleName;	
	private String providerSuffix;	
	private String providerPrefix;	
	private Date assignmentStartDate;	
	private Date assignmentEndDate;	

	static {
		RawFileDataContainerUtils.autoRegisterConvertersForClass();
	}

	protected void buildToString(ToStringBuilder builder) {		
		builder.append("patientIEN", patientIEN);
		builder.append("patientSta3n", patientSta3n);
		builder.append("facility", facility);
		builder.append("teamId", teamId);
		builder.append("teamPurpose", teamPurpose);
		builder.append("teamName", teamName);
		builder.append("practitionerIEN", practitionerIEN);
		builder.append("practitionerSta3n", practitionerSta3n);
		builder.append("providerLastName", providerLastName);
		builder.append("providerFirstName", providerFirstName);
		builder.append("providerMiddleName", providerMiddleName);
		builder.append("providerSuffix", providerSuffix);
		builder.append("providerPrefix", providerPrefix);
		builder.append("assignmentStartDate", assignmentStartDate);
		builder.append("assignmentEndDate", assignmentEndDate);
	}

    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow,
            ClassMapping classMapping) throws Exception
    {
 		int i=0;
 		transactionType = parsedRow.getString(i++);
 		patientIEN = parsedRow.getString(i++);
 		patientSta3n = parsedRow.getString(i++);
		RawFileDataContainerUtils.setConvertedField(this, "facility", parsedRow.getString(i++));
 		
 		RawFileDataContainerUtils.setConvertedField(this, "teamId", parsedRow.getString(i++));
 		RawFileDataContainerUtils.setConvertedField(this, "teamPurpose", parsedRow.getString(i++));
 		teamName = parsedRow.getString(i++);
 		practitionerIEN = parsedRow.getString(i++);
 		practitionerSta3n = parsedRow.getString(i++);
 		providerLastName = parsedRow.getString(i++);
 		providerFirstName = parsedRow.getString(i++);
 		providerMiddleName = parsedRow.getString(i++);
 		providerSuffix = parsedRow.getString(i++);
 		providerPrefix = parsedRow.getString(i++);
 		
 		RawFileDataContainerUtils.setConvertedField(this, "assignmentStartDate", parsedRow.getString(i++));
 		RawFileDataContainerUtils.setConvertedField(this, "assignmentEndDate", parsedRow.getString(i++));

		//verify that all the required fields are specified
		if (!isDataValid()){
			throw new Exception("Required Fields are missing");			
		}
    }

    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception
    {
        // no op as this class is used only for parsing data from a input file
        return null;
    }

    
	/**
	 * Validate all the required fields
	 * @return
	 */
	private boolean isDataValid(){
		
		if (StringUtils.isEmpty(getTransactionType()) ||
			StringUtils.isEmpty(getPatientIEN()) ||
			StringUtils.isEmpty(getPatientSta3n()) ||
			getFacility() == null ||
			getTeamId() == null ||
			getTeamPurpose() == null ||
			StringUtils.isEmpty(teamName) ||
			StringUtils.isEmpty(practitionerIEN) ||
			StringUtils.isEmpty(practitionerSta3n) ||
			StringUtils.isEmpty(providerLastName) ||
			StringUtils.isEmpty(providerFirstName) ||
			getAssignmentStartDate() == null) 
		{		
		    return false;
		}
		return true;
	}
	
	
	public Date getAssignmentEndDate() {
		return assignmentEndDate;
	}


	public void setAssignmentEndDate(Date assignmentEndDate) {
		this.assignmentEndDate = assignmentEndDate;
	}

	public Date getAssignmentStartDate() {
		return assignmentStartDate;
	}


	public void setAssignmentStartDate(Date assignmentStartDate) {
		this.assignmentStartDate = assignmentStartDate;
	}

	public VAFacility getFacility() {
		return this.facility;
	}

	public void setFacility(VAFacility facility) {
		this.facility = facility;
	}


	public String getPractitionerIEN() {
		return this.practitionerIEN;
	}


	public void setPractitionerIEN(String practitionerIEN) {
		this.practitionerIEN = practitionerIEN;
	}

	public String getPractitionerSta3n() {
		return this.practitionerSta3n;
	}

	public void setPractitionerSta3n(String practitionerSta3n) {
		this.practitionerSta3n = practitionerSta3n;
	}

	public String getPractitionerIENSta3n()
	{
		return this.practitionerIEN+"&"+this.practitionerSta3n;
	}

	public String getProviderFirstName() {
		return providerFirstName;
	}


	public void setProviderFirstName(String providerFirstName) {
		this.providerFirstName = providerFirstName;
	}


	public String getProviderLastName() {
		return providerLastName;
	}


	public void setProviderLastName(String providerLastName) {
		this.providerLastName = providerLastName;
	}


	public String getProviderMiddleName() {
		return providerMiddleName;
	}


	public void setProviderMiddleName(String providerMiddleName) {
		this.providerMiddleName = providerMiddleName;
	}


	public String getProviderPrefix() {
		return providerPrefix;
	}


	public void setProviderPrefix(String providerPrefix) {
		this.providerPrefix = providerPrefix;
	}


	public String getProviderSuffix() {
		return providerSuffix;
	}


	public void setProviderSuffix(String providerSuffix) {
		this.providerSuffix = providerSuffix;
	}


	public String getPatientIEN() {
		return patientIEN;
	}

	public void setPatientIEN(String patientIEN) {
		this.patientIEN = patientIEN;
	}

	public String getPatientSta3n() {
		return patientSta3n;
	}

	public void setPatientSta3n(String patientSta3n) {
		this.patientSta3n = patientSta3n;
	}

	public String getPatientIENSta3n()
	{
		return this.patientIEN+"&"+this.patientSta3n;
	}
	
	public Long getTeamId() {
		return teamId;
	}


	public void setTeamId(Long teamId) {
		this.teamId = teamId;
	}


	public String getTeamName() {
		return teamName;
	}


	public void setTeamName(String teamName) {
		this.teamName = teamName;
	}


	public TeamPurpose getTeamPurpose() {
		return teamPurpose;
	}


	public void setTeamPurpose(TeamPurpose teamPurpose) {
		this.teamPurpose = teamPurpose;
	}

	public PatientProviderAssignmentLite getProviderAssignment() {

		PatientProviderAssignmentLite assignment = new PatientProviderAssignmentLite();
		assignment.setAssignmentDate(getAssignmentStartDate());
		assignment.setFacility(getFacility());
		assignment.setTeamId(getTeamId());
		assignment.setTeamName(getTeamName());
		assignment.setTeamPurpose(getTeamPurpose());
		assignment.setUnassignmentDate(getAssignmentEndDate());
		assignment.setPatientId(getPatientIENSta3n());
		return assignment;
	}
	
	public HealthCareProvider getProvider() {
		
		HealthCareProvider provider = new HealthCareProvider();
		provider.setPractitionerId(getPractitionerIENSta3n());
		
		if (this.getProviderFirstName() != null ||
			this.getProviderLastName() != null ||
			this.getProviderMiddleName() != null || 
			this.getProviderPrefix() != null || 
			this.getProviderSuffix() != null) {
		
			Name name = new Name();
			name.setGivenName(this.getProviderFirstName());
			name.setFamilyName(this.getProviderLastName());
			name.setMiddleName(this.getProviderMiddleName());
			name.setPrefix(this.getProviderPrefix());
			name.setSuffix(this.getProviderSuffix());
			
			provider.setName(name);
		}
		
		return provider;
	}


	public String getTransactionType() {
		return transactionType;
	}

	public void setTransactionType(String transactionType) {
		this.transactionType = transactionType;
	}
}
