package gov.va.med.esr.common.batchprocess;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.batchprocess.ProcessStatistics;

/**
 * Holds statistical data fro the OPP Extract process
 * 
 * @author Rajiv Patnaik Created on Mar 28, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class OPPExtractProcessStatistics extends ProcessStatistics
{
    private static final long serialVersionUID = 302946155552167404L;

    private String processType;
    
    private int numberOfCDConditionFileRecords;

    private int numberOfCDDiagnosisFileRecords;

    private int numberOfCDProcedureFileRecords;

    private int numberOfCDDescriptorFileRecords;

    private int numberOfDescriptorQuadriplegia;
    
    private int numberOfDescriptorParaplegia;
    
    private int numberOfDescriptorVegetative;
   
    private int numberOfDescriptorBlindness;
    
    private int numberOfDescriptorAmputation;
    
    private int numberOfDescriptorFunction;
    
    private int numberOfDescriptorDeafness;
    
    private int numberOfEligibilityFileRecords;

    private int numberOfPeriodOfServiceFileRecords;

    private int numberOfRatedDisabilitiesFileRecords;
    
    private int numberOfCombatEpisodeFileRecords;

    private int numberOfRaceFileRecords;

    //Main File Extract Statistics
    private int numberOfMainFileRecords;

    private int numberOfTotalEnrollees;

    private int numberOfDeceasedBeneficiaries;

    private int numberOfCanceledDeclinedEnrollees;

    private int numberOfIneligibleEnrolees;

    private int numberOfPendingMeansTestRecords;

    private int numberOfAutoEnrolledRecords;

    private int numberOfOfficialEnrollees;

    private int numberOfUnOfficialEnrollees;

    private int numberOfActiveHealthInsuranceRecords;

    /**
     * @return Returns the numberOfCDConditionFileRecords.
     */
    public int getNumberOfCDConditionFileRecords()
    {
        return numberOfCDConditionFileRecords;
    }

    public void incrementNumberOfCDConditionFileRecords(int recordsCount)
    {
        numberOfCDConditionFileRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfCDDiagnosisFileRecords.
     */
    public int getNumberOfCDDiagnosisFileRecords()
    {
        return numberOfCDDiagnosisFileRecords;
    }

    public void incrementNumberOfCDDiagnosisFileRecords(int recordsCount)
    {
        this.numberOfCDDiagnosisFileRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfCDProcedureFileRecords.
     */
    public int getNumberOfCDProcedureFileRecords()
    {
        return numberOfCDProcedureFileRecords;
    }

    public void incrementNumberOfCDProcedureFileRecords(int recordsCount)
    {
        numberOfCDProcedureFileRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfCDDescriptorFileRecords.
     */
    public int getNumberOfCDDescriptorFileRecords()
    {
        return numberOfCDDescriptorFileRecords;
    }

    public void incrementNumberOfCDDescriptorFileRecords(int recordsCount)
    {
        numberOfCDDescriptorFileRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfDescriptorQuadriplegia.
     */
    public int getNumberOfDescriptorQuadriplegia()
    {
        return numberOfDescriptorQuadriplegia;
    }

    public void incrementNumberOfDescriptorQuadriplegia(int recordsCount)
    {
    	numberOfDescriptorQuadriplegia += recordsCount;
    }

    /**
     * @return Returns the numberOfDescriptorParaplegia.
     */
    public int getNumberOfDescriptorParaplegia()
    {
        return numberOfDescriptorParaplegia;
    }

    public void incrementNumberOfDescriptorParaplegia(int recordsCount)
    {
    	numberOfDescriptorParaplegia += recordsCount;
    }

    /**
     * @return Returns the numberOfDescriptorVegetative.
     */
    public int getNumberOfDescriptorVegetative()
    {
        return numberOfDescriptorVegetative;
    }

    public void incrementNumberOfDescriptorVegetative(int recordsCount)
    {
    	numberOfDescriptorVegetative += recordsCount;
    }
     /**
     * @return Returns the numberOfDescriptorBlindness.
     */
    public int getNumberOfDescriptorBlindness()
    {
        return numberOfDescriptorBlindness;
    }

    public void incrementNumberOfDescriptorBlindness(int recordsCount)
    {
    	numberOfDescriptorBlindness += recordsCount;
    }
    /**
     * @return Returns the numberOfDescriptorAmputation.
     */
    public int getNumberOfDescriptorAmputation()
    {
        return numberOfDescriptorAmputation;
    }

    public void incrementNumberOfDescriptorAmputation(int recordsCount)
    {
    	numberOfDescriptorAmputation += recordsCount;
    }
    /**
     * @return Returns the numberOfDescriptorFunction.
     */
    public int getNumberOfDescriptorFunction()
    {
        return numberOfDescriptorFunction;
    }

    public void incrementNumberOfDescriptorFunction(int recordsCount)
    {
    	numberOfDescriptorFunction += recordsCount;
    }
    /**
     * @return Returns the numberOfDescriptorDeafness.
     */
    public int getNumberOfDescriptorDeafness()
    {
        return numberOfDescriptorDeafness;
    }

    public void incrementNumberOfDescriptorDeafness(int recordsCount)
    {
    	numberOfDescriptorDeafness += recordsCount;
    } 
    
    /**
     * @return Returns the numberOfEligibilityFileRecords.
     */
    public int getNumberOfEligibilityFileRecords()
    {
        return numberOfEligibilityFileRecords;
    }

    public void incrementNumberOfEligibilityFileRecords(int recordsCount)
    {
        numberOfEligibilityFileRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfPeriodOfServiceFileRecords.
     */
    public int getNumberOfPeriodOfServiceFileRecords()
    {
        return numberOfPeriodOfServiceFileRecords;
    }

    public void incrementNumberOfPeriodOfServiceFileRecords(int recordsCount)
    {
        numberOfPeriodOfServiceFileRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfRatedDisabilitiesFileRecords.
     */
    public int getNumberOfRatedDisabilitiesFileRecords()
    {
        return numberOfRatedDisabilitiesFileRecords;
    }

    public void incrementNumberOfRatedDisabilitiesFileRecords(int recordsCount)
    {
        numberOfRatedDisabilitiesFileRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfRatedDisabilitiesFileRecords.
     */
    public int getNumberOfCombatEpisodeFileRecords()
    {
        return numberOfCombatEpisodeFileRecords;
    }

    public void incrementNumberOfCombatEpisodeFileRecords(int recordsCount)
    {
    	numberOfCombatEpisodeFileRecords += recordsCount;
    }
    
    /**
     * @return Returns the numberOfRaceFileRecords.
     */
    public int getNumberOfRaceFileRecords()
    {
        return numberOfRaceFileRecords;
    }

    public void incrementNumberOfRaceFileRecords(int recordsCount)
    {
    	numberOfRaceFileRecords += recordsCount;
    }
    
    /**
     * @return Returns the numberOfActiveHealthInsuranceRecords.
     */
    public int getNumberOfActiveHealthInsuranceRecords()
    {
        return numberOfActiveHealthInsuranceRecords;
    }

    /**
     * @param numberOfActiveHealthInsuranceRecords
     *            The numberOfActiveHealthInsuranceRecords to increment.
     */
    public void incrementNumberOfActiveHealthInsuranceRecords(
            int recordsCount)
    {
        this.numberOfActiveHealthInsuranceRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfAutoEnrolledRecords.
     */
    public int getNumberOfAutoEnrolledRecords()
    {
        return numberOfAutoEnrolledRecords;
    }

    /**
     * @param numberOfAutoEnrolledRecords
     *            The numberOfAutoEnrolledRecords to increment.
     */
    public void incrementNumberOfAutoEnrolledRecords(int recordsCount)
    {
        this.numberOfAutoEnrolledRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfCanceledDeclinedEnrollees.
     */
    public int getNumberOfCanceledDeclinedEnrollees()
    {
        return numberOfCanceledDeclinedEnrollees;
    }

    /**
     * @param numberOfCanceledDeclinedEnrollees
     *            The numberOfCanceledDeclinedEnrollees to increment.
     */
    public void incrementNumberOfCanceledDeclinedEnrollees(
            int recordsCount)
    {
        this.numberOfCanceledDeclinedEnrollees += recordsCount;
    }

    /**
     * @return Returns the numberOfDeceasedBeneficiaries.
     */
    public int getNumberOfDeceasedBeneficiaries()
    {
        return numberOfDeceasedBeneficiaries;
    }

    /**
     * @param numberOfDeceasedBeneficiaries
     *            The numberOfDeceasedBeneficiaries to increment.
     */
    public void incrementNumberOfDeceasedBeneficiaries(
            int recordsCount)
    {
        this.numberOfDeceasedBeneficiaries += recordsCount;
    }

    /**
     * @return Returns the numberOfIneligibleEnrolees.
     */
    public int getNumberOfIneligibleEnrolees()
    {
        return numberOfIneligibleEnrolees;
    }

    /**
     * @param numberOfIneligibleEnrolees
     *            The numberOfIneligibleEnrolees to increment.
     */
    public void incrementNumberOfIneligibleEnrolees(int recordsCount)
    {
        this.numberOfIneligibleEnrolees += recordsCount;
    }

    /**
     * @return Returns the numberOfMainFileRecords.
     */
    public int getNumberOfMainFileRecords()
    {
        return numberOfMainFileRecords;
    }

    /**
     * @param numberOfMainFileRecords
     *            The numberOfMainFileRecords to increment.
     */
    public void incrementNumberOfMainFileRecords(int recordsCount)
    {
        this.numberOfMainFileRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfOfficialEnrollees.
     */
    public int getNumberOfOfficialEnrollees()
    {
        return numberOfOfficialEnrollees;
    }

    /**
     * @param numberOfOfficialEnrollees
     *            The numberOfOfficialEnrollees to increment.
     */
    public void incrementNumberOfOfficialEnrollees(int recordsCount)
    {
        this.numberOfOfficialEnrollees += recordsCount;
    }

    /**
     * @return Returns the numberOfPendingEnrollmentStatus.
     */
    public int getNumberOfPendingMeansTestRecords()
    {
        return numberOfPendingMeansTestRecords;
    }

    /**
     * @param numberOfPendingEnrollmentStatus
     *            The numberOfPendingEnrollmentStatus to increment.
     */
    public void incrementNumberOfPendingMeansTestRecords(
            int recordsCount)
    {
        this.numberOfPendingMeansTestRecords += recordsCount;
    }

    /**
     * @return Returns the numberOfTotalEnrollees.
     */
    public int getNumberOfTotalEnrollees()
    {
        return numberOfTotalEnrollees;
    }

    /**
     * @param numberOfTotalEnrollees
     *            The numberOfTotalEnrollees to increment.
     */
    public void incrementNumberOfTotalEnrollees(int recordsCount)
    {
        this.numberOfTotalEnrollees += recordsCount;
    }

    /**
     * @return Returns the numberOfUnOfficialEnrollees.
     */
    public int getNumberOfUnOfficialEnrollees()
    {
        return numberOfUnOfficialEnrollees;
    }

    /**
     * @param numberOfUnOfficialEnrollees
     *            The numberOfUnOfficialEnrollees to increment.
     */
    public void incrementNumberOfUnOfficialEnrollees(int recordsCount)
    {
        this.numberOfUnOfficialEnrollees += recordsCount;
    }

    /**
     * @return Returns the processType.
     */
    public String getProcessType()
    {
        return processType;
    }
    /**
     * @param processType The processType to set.
     */
    public void setProcessType(String processType)
    {
        this.processType = processType;
    }
    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);
        builder.append("processType", processType);
        builder.append("numberOfCDConditionFileRecords",
                numberOfCDConditionFileRecords);
        builder.append("numberOfCDDiagnosisFileRecords",
                numberOfCDDiagnosisFileRecords);
        builder.append("numberOfCDProcedureFileRecords",
                numberOfCDProcedureFileRecords);
        builder.append("numberOfCDDescriptorFileRecords",
                numberOfCDDescriptorFileRecords);
        builder.append("numberOfDescriptorQuadriplegia",
        		numberOfDescriptorQuadriplegia);
        builder.append("numberOfDescriptorParaplegia",
        		numberOfDescriptorParaplegia);
        builder.append("numberOfDescriptorVegetative",
        		numberOfDescriptorVegetative);
        builder.append("numberOfDescriptorBlindness",
        		numberOfDescriptorBlindness);
        builder.append("numberOfDescriptorAmputation",
        		numberOfDescriptorAmputation);
        builder.append("numberOfDescriptorFunction",
        		numberOfDescriptorFunction);
        builder.append("numberOfDescriptorDeafness",
        		numberOfDescriptorDeafness);
        builder.append("numberOfEligibilityFileRecords",
                numberOfEligibilityFileRecords);
        builder.append("numberOfPeriodOfServiceFileRecords",
                numberOfPeriodOfServiceFileRecords);
        builder.append("numberOfRatedDisabilitiesFileRecords",
                numberOfRatedDisabilitiesFileRecords);
        builder.append("numberOfCombatEpisodeFileRecords",
        		numberOfCombatEpisodeFileRecords);        
        builder.append("numberOfRaceFileRecords",
        		numberOfRaceFileRecords);        
       builder.append("numberOfMainFileRecords", numberOfMainFileRecords);
        builder.append("numberOfTotalEnrollees", numberOfTotalEnrollees);
        builder.append("numberOfDeceasedBeneficiaries",
                numberOfDeceasedBeneficiaries);
        builder.append("numberOfCanceledDeclinedEnrollees",
                numberOfCanceledDeclinedEnrollees);
        builder
                .append("numberOfIneligibleEnrolees",
                        numberOfIneligibleEnrolees);
        builder.append("numberOfPendingMeansTestRecords",
                numberOfPendingMeansTestRecords);
        builder.append("numberOfAutoEnrolledRecords",
                numberOfAutoEnrolledRecords);
        builder.append("numberOfOfficialEnrollees", numberOfOfficialEnrollees);
        builder.append("numberOfUnOfficialEnrollees",
                numberOfUnOfficialEnrollees);
        builder.append("numberOfActiveHealthInsuranceRecords",
                numberOfActiveHealthInsuranceRecords);
    }

}