package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.QueryIncrementTracker;
import gov.va.med.fw.persistent.QueryInfo;
import gov.va.med.fw.persistent.ScrollableCallback;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

/**
 * 
 * @author Rajiv Patnaik
 * Created on May 8, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class OPPExtractMainFileQueryProcessorImpl extends GenericDAOImpl implements OPPExtractMainFileQueryProcessor, ScrollableCallback 
{
    private static final long serialVersionUID = -3474942534926982774L;

	private OPPExtractMainFileProcess mainFileProcess;
    
    private OPPExtractOutputFileProducer outputFileProducer;
    
    private String queryName;
    
    private int fetchSize; 
       
    /**
     * @return Returns the outputFileProducer.
     */
    public OPPExtractOutputFileProducer getOutputFileProducer()
    {
        return outputFileProducer;
    }
    /**
     * @param outputFileProducer The outputFileProducer to set.
     */
    public void setOutputFileProducer(
            OPPExtractOutputFileProducer outputFileProducer)
    {
        this.outputFileProducer = outputFileProducer;
    }
    
    /**
     * @return Returns the queryName.
     */
    public String getQueryName()
    {
        return queryName;
    }
    /**
     * @param queryName The queryName to set.
     */
    public void setQueryName(String queryName)
    {
        this.queryName = queryName;
    }
    
    /**
     * @return Returns the fetchSize.
     */
    public int getFetchSize()
    {
        return fetchSize;
    }
    /**
     * @param fetchSize The fetchSize to set.
     */
    public void setFetchSize(int fetchSize)
    {
        this.fetchSize = fetchSize;
    }
    
    /* (non-Javadoc)
     * @see gov.va.med.esr.common.batchprocess.OPPExtractMainFileQueryProcessor#processOPPExtractData(gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext)
     */
    public void processOPPExtractData(DataQueryProcessExecutionContext context) throws DAOException
    {
     	QueryInfo qi = new QueryInfo(queryName);
    	qi.setFetchSize(getFetchSize());
   		scroll(this, qi, context);   	   		
    }
    
   /* (non-Javadoc)
	 * @see gov.va.med.fw.persistent.ScrollableCallback#handleScrolledData(java.util.List)
	 */
	public void handleScrolledData(QueryIncrementTracker tracker) {
		if(logger.isDebugEnabled()) {
			logger.debug("Calling OPPExtractMainOutputFileProducer to generate output file of size "
               + tracker.getIncrementalData().size());
		}
        outputFileProducer.generateOutputFile((DataQueryProcessExecutionContext) tracker, tracker.getIncrementalData());
       	mainFileProcess.updateJobResult((DataQueryProcessExecutionContext)tracker);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.med.fw.persistent.ScrollableCallback#continueScrolling()
	 */
	public boolean continueScrolling(QueryIncrementTracker tracker) {
		return !mainFileProcess.isInterrupted((DataProcessExecutionContext) tracker);
	}
	
	/**
	 * @return the mainFileProcess
	 */
	public OPPExtractMainFileProcess getMainFileProcess() {
		return mainFileProcess;
	}
	/**
	 * @param mainFileProcess the mainFileProcess to set
	 */
	public void setMainFileProcess(OPPExtractMainFileProcess mainFileProcess) {
		this.mainFileProcess = mainFileProcess;
	}
}
