package gov.va.med.esr.common.batchprocess;

import java.util.List;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.batchprocess.AbstractDataProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;

/**
 * Processes the data for the main OPP Extract file
 * 
 * @author Rajiv Patnaik Created on Apr 29, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class OPPExtractMainFileProcess extends AbstractDataProcess
{

    private OPPExtractMainFileQueryProcessor mainFileProcessor;
    
    
    /**
     * @return Returns the mainFileProcessor.
     */
    public OPPExtractMainFileQueryProcessor getMainFileProcessor()
    {
        return mainFileProcessor;
    }
    /**
     * @param mainFileProcessor The mainFileProcessor to set.
     */
    public void setMainFileProcessor(
            OPPExtractMainFileQueryProcessor mainFileProcessor)
    {
        this.mainFileProcessor = mainFileProcessor;
    }
    
	protected void executeProcess(DataProcessExecutionContext context) throws Exception {
	    
	    //Call the Query Processor to execute query and extract the data
	    mainFileProcessor.processOPPExtractData((OPPExtractExecutionContext)context);
		
		handleDataProcessCompleted(context);
	}    
	
    /* (non-Javadoc)
     * @see gov.va.med.fw.batchprocess.AbstractDataProcess#processData(gov.va.med.fw.batchprocess.DataProcessExecutionContext, java.util.List)
     */
    protected void processData(DataProcessExecutionContext context,
            List acquiredData)
    {
        // no op

    }

    /* (non-Javadoc)
     * @see gov.va.med.fw.batchprocess.AbstractDataProcess#acquireData(gov.va.med.fw.batchprocess.DataProcessExecutionContext)
     */
    protected List acquireData(DataProcessExecutionContext context)
            throws Exception
    {
        //no op
        return null;
    }

    /* (non-Javadoc)
     * @see gov.va.med.fw.batchprocess.AbstractDataProcess#createProcessStatistics()
     */
    protected ProcessStatistics createProcessStatistics()
    {
        return new OPPExtractProcessStatistics();
    }
    
    protected DataProcessExecutionContext createDataProcessExecutionContext()
    {
        OPPExtractExecutionContext context = new OPPExtractExecutionContext();
		context.setProcessStatistics(createProcessStatistics());
		return context;
    }    
    
    public void afterPropertiesSet() {
    	super.afterPropertiesSet();
    	
    	Validate.notNull(mainFileProcessor, "mainFileProcessor is required");
    	mainFileProcessor.setMainFileProcess(this);
    }
 
    public void updateJobResult(DataQueryProcessExecutionContext context) {
    	if (shouldUpdateJobResult(context)) {
    		super.updateJobResult(context);
    	}
    }
    
	protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
		return context.getProcessStatistics().isTotalNumberMod(OPPExtractConstants.JOB_RESULT_UPDATE_INTERVAL);
	}	

}