package gov.va.med.esr.common.batchprocess;

/**
 * Constants for the OPP Extract Process
 * 
 * @author Rajiv Patnaik Created on Apr 28, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class OPPExtractConstants
{
    //The different process types for OPP. These match the audit-id attribute
    //set in the configuration file
    static final String PROCESS_TYPE_MAIN_EXTRACT = "OPPExtractProcess-Main File";

    static final String PROCESS_TYPE_CD_CONDITION = "OPPExtractProcess-CDCondition";

    static final String PROCESS_TYPE_CD_DIAGNOSIS = "OPPExtractProcess-CDDiagnosis";

    static final String PROCESS_TYPE_CD_PROCEDURE = "OPPExtractProcess-CDProcedure";

    static final String PROCESS_TYPE_CD_DESCRIPTOR = "OPPExtractProcess-CDDescriptor";
 
    static final String PROCESS_TYPE_ELIGIBILITY = "OPPExtractProcess-Eligibility";

    static final String PROCESS_TYPE_PERIOD_OF_SERVICE = "OPPExtractProcess-PeriodOfService";

    static final String PROCESS_TYPE_RATED_DISABILITY = "OPPExtractProcess-RatedDisability";
    
    static final String PROCESS_TYPE_COMBAT_EPISODE = "OPPExtractProcess-CombatEpisode";

    static final String PROCESS_TYPE_RACE = "OPPExtractProcess-Race";

    // Frequency to update the statistics   
	public static final int JOB_RESULT_UPDATE_INTERVAL = 30000;

}