package gov.va.med.esr.common.batchprocess;

import java.util.List;

import gov.va.med.person.idmgmt.VPID;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.io.RawFileDataList;
import gov.va.med.fw.util.StringUtils;
/**
 * 
 * @author Rajiv Patnaik
 * Created on Apr 29, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class OPPExtractCommonOutputFileProducer extends AbstractOPPExtractOutputFileProducer
{

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.batchprocess.AbstractOPPExtractProcess#setIdentityTraitsOnOutputData(gov.va.med.fw.io.RawFileDataList,
     *      gov.va.med.esr.service.PersonIdentityTraits)
     */
    protected RawFileDataList setIdentityTraitsOnOutputData(
            RawFileDataList rawFileDataRow, PersonIdentityTraits traits)
    {
    	//set vpid from the 2nd column into the first column
        rawFileDataRow.set(0,VPID.getShortVPID((String)rawFileDataRow.get(1)));
        rawFileDataRow.set(1, (traits == null ||  traits.getSsn() == null) ? "" : traits.getSsn().getSsnText());

        return rawFileDataRow;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.batchprocess.OPPExtractAbstractFileProducer#incrementStatistics(gov.va.med.esr.common.batchprocess.OPPExtractProcessStatistics,
     *      java.util.List)
     */
    protected void incrementStatistics(OPPExtractExecutionContext context,
            List outputFileData)
    {
        OPPExtractProcessStatistics statistics = (OPPExtractProcessStatistics)context.getProcessStatistics();
        
        setStatistics(statistics, outputFileData);
        
    }

    /**
     * @param statistics
     * @param outputFileData
     */
    private void setStatistics(OPPExtractProcessStatistics statistics, List outputFileData)
    {
        statistics.incrementNumberOfSuccessfulRecords(outputFileData.size());
        
        if(StringUtils.equals(OPPExtractConstants.PROCESS_TYPE_CD_CONDITION, statistics.getProcessName()))
            statistics.incrementNumberOfCDConditionFileRecords(outputFileData.size());

        if(StringUtils.equals(OPPExtractConstants.PROCESS_TYPE_CD_DIAGNOSIS, statistics.getProcessName()))
            statistics.incrementNumberOfCDDiagnosisFileRecords(outputFileData.size());

        if(StringUtils.equals(OPPExtractConstants.PROCESS_TYPE_CD_PROCEDURE, statistics.getProcessName()))
            statistics.incrementNumberOfCDProcedureFileRecords(outputFileData.size());

        if(StringUtils.equals(OPPExtractConstants.PROCESS_TYPE_CD_DESCRIPTOR, statistics.getProcessName()))
            statistics.incrementNumberOfCDDescriptorFileRecords(outputFileData.size());

        if(StringUtils.equals(OPPExtractConstants.PROCESS_TYPE_ELIGIBILITY, statistics.getProcessName()))
            statistics.incrementNumberOfEligibilityFileRecords(outputFileData.size());

        if(StringUtils.equals(OPPExtractConstants.PROCESS_TYPE_PERIOD_OF_SERVICE, statistics.getProcessName()))
            statistics.incrementNumberOfPeriodOfServiceFileRecords(outputFileData.size());

        if(StringUtils.equals(OPPExtractConstants.PROCESS_TYPE_RATED_DISABILITY, statistics.getProcessName()))
            statistics.incrementNumberOfRatedDisabilitiesFileRecords(outputFileData.size());
        
        if(StringUtils.equals(OPPExtractConstants.PROCESS_TYPE_COMBAT_EPISODE, statistics.getProcessName()))
            statistics.incrementNumberOfCombatEpisodeFileRecords(outputFileData.size());        
        
        if(StringUtils.equals(OPPExtractConstants.PROCESS_TYPE_RACE, statistics.getProcessName()))
            statistics.incrementNumberOfRaceFileRecords(outputFileData.size());        
    }
}
