package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;

import java.util.List;

import org.apache.commons.lang.Validate;


/**
 * 
 * @author Rajiv Patnaik Created on Apr 28, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class OPPExtractCommonFileProcess extends AbstractDataProcess
{

    private OPPExtractCommonFileQueryProcessor commonFileProcessor;
    
    
    /**
     * @return Returns the mainFileProcessor.
     */
    public OPPExtractCommonFileQueryProcessor getCommonFileProcessor()
    {
        return commonFileProcessor;
    }
    /**
     * @param CommonFileProcessor The CommonFileProcessor to set.
     */
    public void setCommonFileProcessor(
    		OPPExtractCommonFileQueryProcessor CommonFileProcessor)
    {
        this.commonFileProcessor = CommonFileProcessor;
    }
    
	protected void executeProcess(DataProcessExecutionContext context) throws Exception {
	    
		if (shouldExecuteProcess()) {
			//Call the Query Processor to execute query and extract the data
			commonFileProcessor.processOPPExtractData((OPPExtractExecutionContext)context);
		
			handleDataProcessCompleted(context);
		}
	}    
	
    /* (non-Javadoc)
     * @see gov.va.med.fw.batchprocess.AbstractDataProcess#processData(gov.va.med.fw.batchprocess.DataProcessExecutionContext, java.util.List)
     */
    protected void processData(DataProcessExecutionContext context,
            List acquiredData)
    {
        // no op

    }

    /* (non-Javadoc)
     * @see gov.va.med.fw.batchprocess.AbstractDataProcess#acquireData(gov.va.med.fw.batchprocess.DataProcessExecutionContext)
     */
    protected List acquireData(DataProcessExecutionContext context)
            throws Exception
    {
        //no op
        return null;
    }

    /* (non-Javadoc)
     * @see gov.va.med.fw.batchprocess.AbstractDataProcess#createProcessStatistics()
     */
    protected ProcessStatistics createProcessStatistics()
    {
        return new OPPExtractProcessStatistics();
    }
    
    protected DataProcessExecutionContext createDataProcessExecutionContext()
    {
        OPPExtractExecutionContext context = new OPPExtractExecutionContext();
		context.setProcessStatistics(createProcessStatistics());
		return context;
    }    
    
    public void afterPropertiesSet() {
    	super.afterPropertiesSet();
    	
    	Validate.notNull(commonFileProcessor, "CommonFileProcessor is required");
    	commonFileProcessor.setCommonFileProcess(this);
    }
    
    public void updateJobResult(DataQueryProcessExecutionContext context) {
    	if (shouldUpdateJobResult(context)) {
    		super.updateJobResult(context);
    	}
    }
    
	protected boolean shouldUpdateJobResult(DataQueryProcessExecutionContext context) {
		return context.getProcessStatistics().isTotalNumberMod(OPPExtractConstants.JOB_RESULT_UPDATE_INTERVAL);
	}	

	protected boolean shouldExecuteProcess() {
		return true;
	}
	
 }