package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.lookup.DescriptorType;
import gov.va.med.fw.io.RawFileDataList;

import java.util.Iterator;
import java.util.List;

public class OPPExtractCDDescriptorOutputFileProducer extends OPPExtractCommonOutputFileProducer
{

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.common.batchprocess.OPPExtractAbstractFileProducer#incrementStatistics(gov.va.med.esr.common.batchprocess.OPPExtractProcessStatistics,
     *      java.util.List)
     */
    protected void incrementStatistics(OPPExtractExecutionContext context,
            List outputFileData)
    {
        OPPExtractProcessStatistics statistics = (OPPExtractProcessStatistics)context.getProcessStatistics();

        // customize the statistics for CD descriptors, as the count needs to be added per type
        setStatistics(statistics, outputFileData);
    }

    /**
     * @param statistics
     * @param outputFileData
     */
    private void setStatistics(OPPExtractProcessStatistics statistics, List outputFileData)
    {
        statistics.incrementNumberOfSuccessfulRecords(outputFileData.size());       
        statistics.incrementNumberOfCDDescriptorFileRecords(outputFileData.size());
        
        if (outputFileData != null && !outputFileData.isEmpty()) {
            for (Iterator iter = outputFileData.iterator(); iter.hasNext(); )
            {
               	RawFileDataList dataRow = (RawFileDataList)iter.next();
            	String descriptorCode = (String) dataRow.get(2);
           
            	if (descriptorCode != null) {
	            	if (DescriptorType.CODE_QUADRIPLEGIA.getName().equals(descriptorCode)) {
	            		statistics.incrementNumberOfDescriptorQuadriplegia(1);
	            	} else if (DescriptorType.CODE_PARAPLEGIA.getName().equals(descriptorCode)) {
	            		statistics.incrementNumberOfDescriptorParaplegia(1);
	            	} else if (DescriptorType.CODE_PERSISTENT_VEGETATIVE_STATE.getName().equals(descriptorCode)) {
	            		statistics.incrementNumberOfDescriptorVegetative(1);
	            	} else if (DescriptorType.CODE_LEGAL_BLINDNESS.getName().equals(descriptorCode)) {
	            		statistics.incrementNumberOfDescriptorBlindness(1);
	            	} else if (DescriptorType.CODE_AMPUTATION_DISARTICULATION_DETACHMENT.getName().equals(descriptorCode)) {
	            		statistics.incrementNumberOfDescriptorAmputation(1);
	            	} else if (DescriptorType.CODE_DEFICIENCIES_OF_PHYSICAL_OR_MENTAL_FUNCTION.getName().equals(descriptorCode)) {
	            		statistics.incrementNumberOfDescriptorFunction(1);
	            	} else if (DescriptorType.CODE_DEAFNESS.getName().equals(descriptorCode)) {
	            		statistics.incrementNumberOfDescriptorDeafness(1);
	            	}
            	}
            }        
        }
     }
}
