package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.model.AbstractKeyedEntity;
/**
 * Statistics for the  NCOA Address Verification File process. This is stored
 * in the database.
 * 
 * @author Rajiv Patnaik
 * Created on Mar 9, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class NCOAAddressVerificationFileSummary extends AbstractKeyedEntity
{

    private static final long serialVersionUID = 857428009813528323L;
    /**
     * Total number of vets having addresses with AddressType = Mailing
     */
    private int countOfRecordsScreened;
    /** 
     * Total number of vets after applying the screening criteria
     * This will be the number of records sent to AAC.
     */
    private int countOfRecordsAfterScreening;
    /**
     * NumberOfRecordsScreened - NumberOfRecordsAfterScreening
     */
    private int countOfRecordsExcluded;
    /**
     * Total number of vets having addresses with AddressType = Mailing
     * and have deceased
     */
    private int countOfRecordsDeceased;
    
    /**
     * @return Returns the countOfRecordsAfterScreening.
     */
    public int getCountOfRecordsAfterScreening()
    {
        return countOfRecordsAfterScreening;
    }
    /**
     * @param countOfRecordsAfterScreening The countOfRecordsAfterScreening to set.
     */
    public void setCountOfRecordsAfterScreening(int countOfRecordsAfterScreening)
    {
        this.countOfRecordsAfterScreening = countOfRecordsAfterScreening;
    }
    /**
     * @return Returns the countOfRecordsDeceased.
     */
    public int getCountOfRecordsDeceased()
    {
        return countOfRecordsDeceased;
    }
    /**
     * @param countOfRecordsDeceased The countOfRecordsDeceased to set.
     */
    public void setCountOfRecordsDeceased(int countOfRecordsDeceased)
    {
        this.countOfRecordsDeceased = countOfRecordsDeceased;
    }
    /**
     * @return Returns the countOfRecordsExcluded.
     */
    public int getCountOfRecordsExcluded()
    {
        return countOfRecordsExcluded;
    }
    /**
     * @param countOfRecordsExcluded The countOfRecordsExcluded to set.
     */
    public void setCountOfRecordsExcluded(int countOfRecordsExcluded)
    {
        this.countOfRecordsExcluded = countOfRecordsExcluded;
    }
    /**
     * @return Returns the countOfRecordsScreened.
     */
    public int getCountOfRecordsScreened()
    {
        return countOfRecordsScreened;
    }
    /**
     * @param countOfRecordsScreened The countOfRecordsScreened to set.
     */
    public void setCountOfRecordsScreened(int countOfRecordsScreened)
    {
        this.countOfRecordsScreened = countOfRecordsScreened;
    }
}
