package gov.va.med.esr.common.batchprocess;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.util.InvalidConfigurationException;
/**
 * 
 * @author Rajiv Patnaik
 * Created on May 31, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class NCOAAddressVerificationFileProcessStatistics extends
        ProcessStatistics
{
    private static final long serialVersionUID = 8731729340372380614L;
    
    private int numberOfNoIdentityTraitsRecords;

    private NCOAAddressVerificationFileSummary ncoaAddressVerificationFileSummary;
    
    
    /**
     * @return Returns the ncoaAddressVerificationFileSummary.
     */
    public NCOAAddressVerificationFileSummary getNcoaAddressVerificationFileSummary()
    {
        return ncoaAddressVerificationFileSummary;
    }
    /**
     * @param ncoaAddressVerificationFileSummary The ncoaAddressVerificationFileSummary to set.
     */
    public void setNcoaAddressVerificationFileSummary(
            NCOAAddressVerificationFileSummary ncoaAddressVerificationFileSummary)
    {
        this.ncoaAddressVerificationFileSummary = ncoaAddressVerificationFileSummary;
    }
    
    /**
     * @param numberOfNoIdentityTraitsRecords The numberOfNoIdentityTraitsRecords to set.
     */
    public void setNumberOfNoIdentityTraitsRecords(int numberOfNoIdentityTraitsRecords) {
        this.numberOfNoIdentityTraitsRecords = numberOfNoIdentityTraitsRecords;
    }
    
    /**
     * @return Returns the numberOfNoIdentityTraitsRecords.
     */
    public int getNumberOfNoIdentityTraitsRecords() {
        return numberOfNoIdentityTraitsRecords;
    }
    
    public void incrementNumberOfNoIdentityTraitsRecords() {
        incrementNumberOfNoIdentityTraitsRecords(1);
    }
    
    public void incrementNumberOfNoIdentityTraitsRecords(int recordsCount) {
        numberOfNoIdentityTraitsRecords += recordsCount;
        incrementNumberOfTotalRecords(recordsCount);
    }
    
    protected void appendStats(ProcessStatistics stats) {
        NCOAAddressVerificationFileProcessStatistics incoming = (NCOAAddressVerificationFileProcessStatistics) stats;
        this.incrementNumberOfNoIdentityTraitsRecords(incoming.getNumberOfNoIdentityTraitsRecords());
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("numberOfNoIdentityTraitsRecords", getNumberOfNoIdentityTraitsRecords());
        
        if(ncoaAddressVerificationFileSummary != null)
        {
            builder.append("Process Ended: ", getProcessingEndDate()); 
            builder.append("Total Number of Records Included in the screening process: ", 
                    ncoaAddressVerificationFileSummary.getCountOfRecordsScreened()); 
            builder.append("Total Number of Records excluded based on screening criteria: ", 
                    ncoaAddressVerificationFileSummary.getCountOfRecordsExcluded()); 
            builder.append("Total Number of Records Excluded based on missing identity traits: ", 
                    getNumberOfNoIdentityTraitsRecords()); 
            builder.append("Total Number of Deceased Records identified in the screening process: ", 
                    ncoaAddressVerificationFileSummary.getCountOfRecordsDeceased()); 
            builder.append("Total Number of Records sent to AAC: ", 
                    ncoaAddressVerificationFileSummary.getCountOfRecordsAfterScreening());
            //There will be one file per process.
            builder.append("Total Number of Files sent to AAC: ", 1);
        }else{
            throw new InvalidConfigurationException("NCOAAddressVerificationFileSummary is null in NCOAAddressVerificationFileProcessStatistics. Cannot generate statistics");
        }
    }
    
}
