package gov.va.med.esr.common.batchprocess;

import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * 
 * @author Rajiv Patnaik
 * Created on Feb 24, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class NCOAAddressVerificationFileData extends AbstractKeyedEntity
{ 
    private static final long serialVersionUID = 1165994050471290598L;

    private String formID;
    private String lastName;
    private String firstName;
    private String middleInitial;
    private String suffix;
    private String ssn;
    private String gender;
    private ImpreciseDate dateOfBirth;
    private Date dateLastUpdated;
    private String addressLine1;
    private String addressLine2;
    private String city;
    private String state;
    private String zipCode;
    private String zipPlus4;
    private String ICN;
    
    /**
     * @return Returns the addressLine1.
     */
    public String getAddressLine1()
    {
        return addressLine1;
    }
    /**
     * @param addressLine1 The addressLine1 to set.
     */
    public void setAddressLine1(String addressLine1)
    {
        this.addressLine1 = addressLine1;
    }
    /**
     * @return Returns the addressLine2.
     */
    public String getAddressLine2()
    {
        return addressLine2;
    }
    /**
     * @param addressLine2 The addressLine2 to set.
     */
    public void setAddressLine2(String addressLine2)
    {
        this.addressLine2 = addressLine2;
    }
    /**
     * @return Returns the city.
     */
    public String getCity()
    {
        return city;
    }
    /**
     * @param city The city to set.
     */
    public void setCity(String city)
    {
        this.city = city;
    }

    /**
     * @return Returns the dateLastUpdated.
     */
    public Date getDateLastUpdated()
    {
        return dateLastUpdated;
    }
    /**
     * @param dateLastUpdated The dateLastUpdated to set.
     */
    public void setDateLastUpdated(Date dateLastUpdated)
    {
        this.dateLastUpdated = dateLastUpdated;
    }
    /**
     * @return Returns the dateOfBirth.
     */
    public ImpreciseDate getDateOfBirth()
    {
        return dateOfBirth;
    }
    /**
     * @param dateOfBirth The dateOfBirth to set.
     */
    public void setDateOfBirth(ImpreciseDate dateOfBirth)
    {
        this.dateOfBirth = dateOfBirth;
    }
    /**
     * @return Returns the firstName.
     */
    public String getFirstName()
    {
        return firstName;
    }
    /**
     * @param firstName The firstName to set.
     */
    public void setFirstName(String firstName)
    {
        this.firstName = firstName;
    }
    
    /**
     * @return Returns the formID.
     */
    public String getFormID()
    {
        return formID;
    }
    /**
     * @param formID The formID to set.
     */
    public void setFormID(String formID)
    {
        this.formID = formID;
    }
    /**
     * @return Returns the gender.
     */
    public String getGender()
    {
        return gender;
    }
    /**
     * @param gender The gender to set.
     */
    public void setGender(String gender)
    {
        this.gender = gender;
    }
    /**
     * @return Returns the iCN.
     */
    public String getICN()
    {
        return ICN;
    }
    /**
     * @param icn The iCN to set.
     */
    public void setICN(String icn)
    {
        ICN = icn;
    }
    /**
     * @return Returns the lastName.
     */
    public String getLastName()
    {
        return lastName;
    }
    /**
     * @param lastName The lastName to set.
     */
    public void setLastName(String lastName)
    {
        this.lastName = lastName;
    }
    /**
     * @return Returns the middleInitial.
     */
    public String getMiddleInitial()
    {
        return middleInitial;
    }
    /**
     * @param middleInitial The middleInitial to set.
     */
    public void setMiddleInitial(String middleInitial)
    {
        this.middleInitial = middleInitial;
    }
    /**
     * @return Returns the ssn.
     */
    public String getSsn()
    {
        return ssn;
    }
    /**
     * @param ssn The ssn to set.
     */
    public void setSsn(String ssn)
    {
        this.ssn = ssn;
    }
    /**
     * @return Returns the state.
     */
    public String getState()
    {
        return state;
    }
    /**
     * @param state The state to set.
     */
    public void setState(String state)
    {
        this.state = state;
    }
    /**
     * @return Returns the suffix.
     */
    public String getSuffix()
    {
        return suffix;
    }
    /**
     * @param suffix The suffix to set.
     */
    public void setSuffix(String suffix)
    {
        this.suffix = suffix;
    }
    
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);

        builder.append("formID", this.formID);
        builder.append("lastName", this.lastName);
        builder.append("firstName", this.firstName);
        builder.append("middleInitial", this.middleInitial);
        builder.append("suffix", this.suffix);
        //builder.append("ssn", this.ssn);
        builder.append("gender", this.gender);
        builder.append("dateOfBirth", this.dateOfBirth);
        builder.append("dateLastUpdated", this.dateLastUpdated);
        builder.append("addressLine1", this.addressLine1);
        builder.append("addressLine2", this.addressLine2);
        builder.append("city", this.city);
        builder.append("state", this.state);
        builder.append("zipCode", this.zipCode);
        builder.append("zipPlus4", this.zipPlus4);
        builder.append("ICN", this.ICN);
    }
    
    public String getZipCodeWithExtension() {
    	String data = null;
    	if(StringUtils.isNotEmpty(zipCode)) {
    		if(StringUtils.isNotEmpty(zipPlus4)) {
    			data = zipCode + "-" + zipPlus4;
    		} else {
    			data = zipCode;
    		}
    	}
    	return data;
    }
    
	/**
	 * @return Returns the zipCode.
	 */
	public String getZipCode() {
		return zipCode;
	}
	/**
	 * @param zipCode The zipCode to set.
	 */
	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}
	/**
	 * @return Returns the zipPlus4.
	 */
	public String getZipPlus4() {
		return zipPlus4;
	}
	/**
	 * @param zipPlus4 The zipPlus4 to set.
	 */
	public void setZipPlus4(String zipPlus4) {
		this.zipPlus4 = zipPlus4;
	}      
    
}
