package gov.va.med.esr.common.batchprocess;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.batchprocess.DataQueryProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;

/**
 * A class to collect statistics for IDM AddressSeeding batch job 
 */
public class MVIAddressExportProcessStatistics extends DataQueryProcessStatistics {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5772968339868166280L;

	private static final String NUMBER_OF_IGNORED_RECORDS= "numberOfIgnoredRecords";	
	
	private int numberOfIgnoredRecords;
	
	protected void appendStats(ProcessStatistics stats) {
		MVIAddressExportProcessStatistics incoming = (MVIAddressExportProcessStatistics) stats;
		this.incrementNumberOfIgnoredRecords(incoming.getNumberOfIgnoredRecords());
	}

	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		
		builder.append(NUMBER_OF_IGNORED_RECORDS, numberOfIgnoredRecords);
	}


	public int getNumberOfIgnoredRecords() {
		return numberOfIgnoredRecords;
	}

	public void setNumberOfIgnoredRecords(int numberOfIgnoredRecords) {
		this.numberOfIgnoredRecords = numberOfIgnoredRecords;
	}

	public void incrementNumberOfIgnoredRecords() {
		incrementNumberOfIgnoredRecords(1);
	}
	
	public void incrementNumberOfIgnoredRecords(int count) {
		numberOfIgnoredRecords += count;
		incrementNumberOfTotalRecords(count);
	}
}
