// Package 
package gov.va.med.esr.common.batchprocess;

// Framework Classes
import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.util.SystemUtils;

/**
 * A batch process that logs memory usage statistics.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class LogMemoryUsageProcess extends AbstractScheduledProcess
{
    /**
     * Executes this batch process.
     *
     * @param args process arguments
     *
     * @throws Exception if any problems were encountered.
     */
    protected void executeProcess(ScheduledProcessInvocationContext context) throws Exception
    {
        // Log the memory after garbage collection is called
        SystemUtils.logMemory(true);
    }
}
