/**
 * 
 */
package gov.va.med.esr.common.batchprocess;

import java.io.Serializable;

import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.lookup.ConflictLocation;

/**
 * @author DNS   KATIKM
 * Stores the resultes from processing the VSSC Data file (single row)
 */
public class LoadVSSCDataResult implements Serializable {

	private static final long serialVersionUID = -4885368055508908441L;
	public static final String EXCEPTION_REASON_NO_MATCH = "EXCEPTION_REASON_NO_MATCH";
	public static final String EXCEPTION_REASON_FAILED = "EXCEPTION_REASON_FAILED";
	public static final String EXCEPTION_REASON_NEW_PERSON = "EXCEPTION_REASON_NEW_PERSON";
	public static String EXP_REQUIRED_FIELDS_MISSING_INVALID = "Required Fields are missing or inavlid";
	public static String EXP_CONSISTENCY_CHECKS_FAILED = "Consistency Checks Failed";

    private int countOEFAccepted = 0;
    private int countOEFRejected = 0;
    private int countOIFAccepted = 0;
    private int countOIFRejected = 0;
    private int countUnknownAccepted = 0;
    private int countUnknownRejected = 0;
    private int countUnspecifiedAccepted = 0;
    private int countUnspecifiedRejected = 0;
    private int countNewPersonRejected = 0;
    private int countNoMatchRejected = 0;
    private int countCCRejected = 0;
    private int countMissingInvalidRejected = 0;
    
    public void incrementRejected(CombatEpisode combatEpisode){
    	String locationCode = combatEpisode.getConflictLocation().getCode();
    	if (ConflictLocation.CODE_OEF.getCode().equals(locationCode)){
    		incrementCountOEFRejected();
    	}
    	else if (ConflictLocation.CODE_OIF.getCode().equals(locationCode)){
    		incrementCountOIFRejected();
    	}
    	else if (ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode().equals(locationCode)){
    		incrementCountUnknownRejected();
    	}
    	else if (ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(locationCode)){
    		incrementCountUnspecifiedRejected();
    	}
    }
    public void incrementAccepted(CombatEpisode combatEpisode){
    	String locationCode = combatEpisode.getConflictLocation().getCode();
    	if (ConflictLocation.CODE_OEF.getCode().equals(locationCode)){
    		incrementCountOEFAccepted();
    	}
    	else if (ConflictLocation.CODE_OIF.getCode().equals(locationCode)){
    		incrementCountOIFAccepted();
    	}
    	else if (ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode().equals(locationCode)){
    		incrementCountUnknownAccepted();
    	}
    	else if (ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(locationCode)){
    		incrementCountUnspecifiedAccepted();
    	}
    }    
    public void incrementCountOEFAccepted() {
		this.countOEFAccepted++;
	}

	public void incrementCountOEFRejected() {
		this.countOEFRejected++;
	}

	public void incrementCountOIFAccepted() {
		this.countOIFAccepted++;
	}

	public void incrementCountOIFRejected() {
		this.countOIFRejected++;
	}

	public void incrementCountUnknownAccepted() {
		this.countUnknownAccepted++;
	}

	public void incrementCountUnknownRejected() {
		this.countUnknownRejected++;
	}

	public void incrementCountUnspecifiedAccepted() {
		this.countUnspecifiedAccepted++;
	}

	public void incrementCountUnspecifiedRejected() {
		this.countUnspecifiedRejected++;
	}

	/*    
    private String exceptionReason = null;
    private boolean noMatch = false;
    private boolean failed = false;

	public String getExceptionReason() {
		return this.exceptionReason;
	}

	public void setExceptionReason(String exceptionReason) {
		this.exceptionReason = exceptionReason;
	}

	public boolean isNoMatch() {
		return this.noMatch;
	}

	public void setNoMatch(boolean noMatch) {
		this.noMatch = noMatch;
	}

	public boolean isFailed() {
		return this.failed;
	}

	public void setFailed(boolean failed) {
		this.failed = failed;
	}
*/
	public int getCountOEFAccepted() {
		return this.countOEFAccepted;
	}

	public int getCountOEFRejected() {
		return this.countOEFRejected;
	}

	public int getCountOIFAccepted() {
		return this.countOIFAccepted;
	}

	public int getCountOIFRejected() {
		return this.countOIFRejected;
	}

	public int getCountUnknownAccepted() {
		return this.countUnknownAccepted;
	}

	public int getCountUnknownRejected() {
		return this.countUnknownRejected;
	}

	public int getCountUnspecifiedAccepted() {
		return this.countUnspecifiedAccepted;
	}

	public int getCountUnspecifiedRejected() {
		return this.countUnspecifiedRejected;
	}
	
	public int getCountNewPersonRejected() {
		return this.countNewPersonRejected;
	}
	public void incrementCountNewPersonRejected() {
		this.countNewPersonRejected++;
	}
	public void incrementCountNewPersonRejected(int count) {
		this.countNewPersonRejected = this.countNewPersonRejected + count;
	}	
	public int getCountCCRejected() {
		return this.countCCRejected;
	}
	public int getCountMissingInvalidRejected() {
		return this.countMissingInvalidRejected;
	}
	public void incrementCountCCRejected() {
		this.countCCRejected++;
	}
	public void incrementCountMissingInvalidRejected() {
		this.countMissingInvalidRejected++;
	}
	public int getCountNoMatchRejected() {
		return this.countNoMatchRejected;
	}
	public void incrementCountNoMatchRejected() {
		this.countNoMatchRejected++;
	}
	public int getTotalAccepted() {
		return countOEFAccepted + countOIFAccepted + countUnknownAccepted + countUnspecifiedAccepted;
	}
	/**
	 * Total rejected (error records)
	 * @return
	 */
	public int getTotalRejected() {
		return countMissingInvalidRejected + countCCRejected + 
				countNoMatchRejected + countNewPersonRejected + 
				countOEFRejected + countOIFRejected + countUnknownRejected + countUnspecifiedRejected;
	}
	/**
	 * Total rejected in rules (no enrollment or overlapping records)
	 * @return
	 */
	public int getTotalNotFiled() {
		return countNewPersonRejected + countOEFRejected + countOIFRejected + countUnknownRejected + countUnspecifiedRejected;
	}
}
