package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.registry.RegistryLoadException;
import gov.va.med.esr.common.model.registry.RegistryLoadStatistics;
import gov.va.med.fw.batchprocess.DataFileProcessStatistics;
import gov.va.med.fw.util.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Statistics for the Load Registry process
 * 
 * @author Rajiv Patnaik
 * Created on Apr 17, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class LoadRegistryProcessStatistics extends DataFileProcessStatistics
{ 
    private static final long serialVersionUID = -5129989858953868149L;
    
    private RegistryLoadStatistics registryLoadStatistics;
    
    public LoadRegistryProcessStatistics()
    {
        registryLoadStatistics = new RegistryLoadStatistics();
    }

    /**
     * @param newRegistryEntriesInserted The newRegistryEntriesInserted to set.
     */
    public void incrementNewRegistryEntriesInserted()
    {
        registryLoadStatistics.setNewRegistryEntriesInserted(registryLoadStatistics.getNewRegistryEntriesInserted()+ 1);
    }
    
    /**
     * @param recordsAmbigouslyMatched The recordsAmbigouslyMatched to set.
     */
    public void incrementRecordsAmbigouslyMatched()
    {
        registryLoadStatistics.setRecordsAmbiguouslyMatched(registryLoadStatistics.getRecordsAmbiguouslyMatched()+ 1);
    }

    /**
     * @param recordsMatchedToExistingRecords The recordsMatchedToExistingRecords to set.
     */
    public void incrementRecordsMatchedToExistingRecords()
    {
        registryLoadStatistics.setRecordsMatchedToExistingRecords(registryLoadStatistics.getRecordsMatchedToExistingRecords()+ 1);
    }

    /**
     * @param recordsNotMatchedToExistingRecords The recordsNotMatchedToExistingRecords to set.
     */
    public void incrementRecordsNotMatchedToExistingRecords()
    {
        registryLoadStatistics.setRecordsNotMatchedToExistingRecords(registryLoadStatistics.getRecordsNotMatchedToExistingRecords()+ 1);
    }
    /**
     * @param recordsPassingConsistenceyCheck The recordsPassingConsistenceyCheck to set.
     */
    public void incrementRecordsPassedConsistencyCheck()
    {
        registryLoadStatistics.setRecordsPassedConsistencyCheck(registryLoadStatistics.getRecordsPassedConsistencyCheck()+ 1);
    }
    
    
    /**
     * @param recordsFailedConsistencyCheck The recordsFailedConsistencyCheck to set.
     */
    public void incrementRecordsFailedConsistencyCheck()
    {
        registryLoadStatistics.setRecordsFailedConsistencyCheck(registryLoadStatistics.getRecordsFailedConsistencyCheck()+ 1);
    }
    /**
     * @param recordsRead The recordsRead to set.
     */
    public void incrementRecordsRead()
    {
        registryLoadStatistics.setRecordsRead(registryLoadStatistics.getRecordsRead()+ 1);
    }
 
    /**
     * @param registryType The registryType to set.
     */
    public void setRegistryType(RegistryType registryType)
    {
        registryLoadStatistics.setRegistryType(registryType);
    }
    
    public void addRegistryExceptionDetail(ReportExceptionType exceptionType, String exceptionText)
    {
        RegistryLoadException exceptionDetail = new RegistryLoadException();
        exceptionDetail.setReportExceptionType(exceptionType);
        exceptionDetail.setExceptionRecordText(exceptionText);
        registryLoadStatistics.addRegistryLoadException(exceptionDetail);
    }
    
    /**
     * @return Returns the registryLoadStatistics.
     */
    public RegistryLoadStatistics getRegistryLoadStatistics()
    {
        return registryLoadStatistics;
    }
  	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("registryType", registryLoadStatistics != null && registryLoadStatistics.getRegistryType() !=null ? registryLoadStatistics.getRegistryType().getDescription():StringUtils.EMPTY);  
        builder.append("recordsRead", registryLoadStatistics.getRecordsRead());
        builder.append("recordsPassedConsistencyCheck", registryLoadStatistics.getRecordsPassedConsistencyCheck());
        builder.append("recordsFailedConsistencyCheck", registryLoadStatistics.getRecordsFailedConsistencyCheck());
        builder.append("recordsNotMatchedToExistingRecords",registryLoadStatistics.getRecordsNotMatchedToExistingRecords());
        builder.append("recordsMatchedToExistingRecords", registryLoadStatistics.getRecordsMatchedToExistingRecords());
        builder.append("recordsAmbiguouslyMatched", registryLoadStatistics.getRecordsAmbiguouslyMatched());
        builder.append("newRegistryEntriesInserted",registryLoadStatistics.getNewRegistryEntriesInserted());
    
	}

}
