package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.registry.RegistryLoadStatistics;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.SimpleDataFileProcessCompletedHandler;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import java.util.List;
/**
 * Write to an exception file for the data that failed rules validation
 * Persist the summary to a summary table
 * Delete the processed file
 *  
 * @author Rajiv Patnaik
 * Created on Apr 17, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class LoadRegistryProcessCompletedHandler extends SimpleDataFileProcessCompletedHandler
{
    DAOOperations dao ;
        
    /**
     * @return Returns the dao.
     */
    public DAOOperations getDao()
    {
        return dao;
    }
    /**
     * @param dao The dao to set.
     */
    public void setDao(DAOOperations dao)
    {
        this.dao = dao;
    }


    /* (non-Javadoc)
     * @see gov.va.med.fw.batchprocess.DataProcessCompletedHandler#dataProcessingComplete(gov.va.med.fw.batchprocess.DataProcessExecutionContext)
     */
    public void dataProcessingComplete(DataProcessExecutionContext context)
    {
        //Persist to the Batch load summary table
        LoadRegistryProcessStatistics statistics = (LoadRegistryProcessStatistics)context.getProcessStatistics();
        
        RegistryLoadStatistics summary = statistics.getRegistryLoadStatistics();
        try
        {
            getDao().saveObject(summary);
        } catch (DAOException e)
        {
            logger.error("Exception persisting  RegistryLoadStatistics " +summary);
            
            throw new RuntimeException("Unable to persist RegistryLoadStatistics", e);
        }
        
        //Delete the file.
        super.dataProcessingComplete(context);
    }

	protected boolean shouldDeleteFile(List exceptionData) {
		return true;
	}    
}
