package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.fw.io.RawFileDataContainer;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.InvalidArgumentException;
import gov.va.med.fw.util.StringUtils;

import org.apache.commons.lang.builder.ToStringBuilder;
/**
 * Superclass for all Load Registry File Data
 * 
 * @author Rajiv Patnaik
 * Created on Apr 17, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public abstract class LoadRegistryFileData extends AbstractEntity implements RawFileDataContainer
{

    private static final long serialVersionUID = -1370346746640850300L;
    //Constants defining the identity trait fields in the data records
    protected static final String LAST_NAME = "lastName";
    protected static final String FIRST_NAME = "firstName";
    protected static final String MIDDLE_NAME = "middleName";
    protected static final String SUFFIX = "prefix";
    protected static final String PREFIX = "suffix";
    protected static final String EDUCATIONAL_DEGREE = "educationalDegree";
    protected static final String SSN = "ssn";
    protected static final String REGISTRY_TYPE = "registryType";
    protected static final String EXCEPTION_REASON = "exceptionReason";

    protected final int SSN_LENGTH = 9;
    
    private Registry registry;
    
    //Used while writing out to exception file
    private String exceptionReason;

    /**
     * @return Returns the registry.
     */
    public Registry getRegistry()
    {
        return registry;
    }
    /**
     * @param registry The registry to set.
     */
    public void setRegistry(Registry registry)
    {
        this.registry = registry;
    }
    
    /**
     * @return Returns the exceptionReason.
     */
    public String getExceptionReason()
    {
        return exceptionReason;
    }
    /**
     * @param exceptionReason The exceptionReason to set.
     */
    public void setExceptionReason(String exceptionReason)
    {
        this.exceptionReason = exceptionReason;
    }
    
    protected String transformLookup(Lookup lookup)
    {
        return lookup == null ? null : lookup.getCode();
    } 
    
    /* (non-Javadoc)
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
		builder.append("registry", registry);
		builder.append("exceptionReason", exceptionReason);
    }
    
    protected Boolean buildBooleanValue(String value) throws InvalidArgumentException
    {
    	Boolean convertedValue = null;
    	
    	if(!StringUtils.isEmpty(value))
    	{
	    	if("y".equalsIgnoreCase(value) || 
	    			"true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value))
	    	{
	    		convertedValue = Boolean.TRUE;
	    	}else if ("n".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value) 
	    			|| "no".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value))
	    	{
	    		convertedValue = Boolean.FALSE;
	    	}else {
	    		throw new InvalidArgumentException("Invalid argument to build boolean value: "+value, null);
	    	}
    	}
    	return convertedValue;
    }
    protected Integer buildIntegerValue(String value) throws InvalidArgumentException
    {
    	return StringUtils.isEmpty(value)? null : Integer.valueOf(value);
    }    

    /**
     * Strips white space from the input value and, if empty, returns the value.
     * If not empty, left pads with zeros. 
     * @param value
     * @return
     * @throws InvalidArgumentException
     */
    protected String buildSsnValue(String value) throws InvalidArgumentException
    {
        String ssn = StringUtils.stripToNull(value);
        
        if (StringUtils.isEmpty(ssn))
        {
            return ssn;
        }
        else
        {
            return StringUtils.leftPadWithZero(ssn, SSN_LENGTH);
        }
    }    
}
