package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;

import java.util.List;

/**
 * Contains logic to inactivate completed reports.
 *
 * @author Venky Kulllampalle
 * @version 1.0
 *
 * Copyright  2006 VHA. All rights reserved
 */
public class InactivateCompletedReportsProcess extends AbstractReportProcess
{    
    
   /**
    * This method uses System Parameter Service to retrieve Archived Reports Parameter.
    * Calls Standard Report Service to inactivate completed reports.
    * Updates process statistics.
    * @param context
    * @param acquiredData
    * 
    */
    public void processData(DataProcessExecutionContext context, List acquiredData)
    {
        try
        {  
            //Get the system parameter for Archived Reports Parameter.
            SystemParameter sysParameter= getSystemParameterService().getByName(SystemParameter.ARCHIVE_REPORTS_PARAMETER);
            if(sysParameter!=null)
            {
                int noOfRecords=this.getReportService().inactivateCompletedReports(getUpdateQueryString(), getAuditInfo(), sysParameter);
                context.getProcessStatistics().setNumberOfTotalRecords(
                        context.getProcessStatistics().getNumberOfTotalRecords()                            
                                + noOfRecords);
                context.getProcessStatistics().setNumberOfSuccessfulRecords(
                        context.getProcessStatistics().getNumberOfSuccessfulRecords()                            
                                + noOfRecords);
            }
      } catch (Exception e)
        {
           
            String errorMessage = "Error while executing Inactivate Completed Reports batch process :"
                    + " Reason: " + e.getMessage();
    
            context.getExceptionData().add(errorMessage);
    
            if (logger.isWarnEnabled())
                logger.warn(errorMessage, e);
        }
    }
}