package gov.va.med.esr.common.batchprocess;


import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.util.StringUtils;

/*
 * parses incoming files from CMS with Code1 Reject Failures for ACA 1095B mail requests
 *
 */

public class Import1095BResponsesPDFFileData  extends
           AbstractRawFileDataContainer  {
	/**
	 *
	 */
	private static final long serialVersionUID = -1564583385245001470L;
	private String formNum;
	private String vpid;
	private String rejectCode;
	private String stringValue;
	private String name = "run";
	private String required = "true";


	protected void buildToString(ToStringBuilder builder) {
		builder.append("formNum", formNum).append("vpid", vpid).
			append("rejectCode", rejectCode);
	}

    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow,
            ClassMapping classMapping) throws Exception
    {
    	int i = 0;
    	this.setFormNumText(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setVPID(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setRejectCode(StringUtils.stripToNull(parsedRow.getString(i++)));
    }

	protected List validateData(){
		ArrayList errors = new ArrayList();
		if ( formNum == null || formNum.length() <= 0 ) {
			errors.add("Missing FormNumber");
		}
		if ( vpid == null || vpid.length() <= 0 ) {
			errors.add("Missing VPID");
		}
		if ( rejectCode == null || rejectCode.length() <= 0) {
			errors.add("Missing Reject Code");
		}
		return errors;
	}
    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception
    {
        // no op as this class is used only for parsing data from a input file
        return null;
    }

	public String getFormNumText() {
		return formNum;
	}

	public void setFormNumText(String formNum) {
		this.formNum = formNum;
	}

	public String getVPID() {
		return vpid;
	}

	public void setVPID(String Vpid) {
		this.vpid = Vpid;
	}

	public String getRejectCode() {
		return rejectCode;
	}

	public void setRejectCode(String rejectCode) {
		this.rejectCode = rejectCode;
	}
	
	public String getStringValue() {
		return stringValue;
	}

	public void setStringValue(String stringValue) {
		this.stringValue = stringValue;
	}


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}


	public String getRequired() {
		return required;
	}


	public void setRequired(String required) {
		this.required = required;
	}


}
