package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.person.idmgmt.VPID;

import org.apache.commons.lang.builder.ToStringBuilder;

public class HealthBenefitPlanData extends AbstractEntity {

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4428932523399598763L;
	/**
	ProductID^HandbookRequestId^VPID^CategoryCode^HealthBenefitCode^CoveragePlanCode
	e.g.
	F400H ^123456789^2004341118V132456^Enrollment^EN01^EN01001
	F400H ^123456789^2004341118V132456^Dental^DN01^DN01001
	F400H ^123456789^2004341118V132456^EyeGlasses^EY01^EY01001
	**/
	private String productID;
	private String handbookRequestId;
	private String icn;
	private String categoryCode;
	private String healthBenefitCode;
	private String coveragePlanCode; 
	private String releaseControlNumber;
	
	
	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	public String getCoveragePlanCode() {
		return coveragePlanCode;
	}

	public void setCoveragePlanCode(String coveragePlanCode) {
		this.coveragePlanCode = coveragePlanCode;
	}

	public String getHandbookRequestId() {
		return handbookRequestId;
	}

	public void setHandbookRequestId(String handbookRequestId) {
		this.handbookRequestId = handbookRequestId;
	}


	public String getHealthBenefitCode() {
		return healthBenefitCode;
	}

	public void setHealthBenefitCode(String healthBenefitCode) {
		this.healthBenefitCode = healthBenefitCode;
	}

	public String getProductID() {
		return productID;
	}

	public void setProductID(String productID) {
		this.productID = productID;
	}

	public String getIcn() {
		return icn;
	}

	public String getVpid() {
		return VPID.padIcn(getIcn());
	}
	
	public void setIcn(String icn) {
		this.icn = icn;
	}
	
	

	public String getReleaseControlNumber() {
		return releaseControlNumber;
	}

	public void setReleaseControlNumber(String releaseControlNumber) {
		this.releaseControlNumber = releaseControlNumber;
	}

	protected void buildToString(ToStringBuilder builder) {
		builder.append("productID", productID).
				append("handbookRequestId", handbookRequestId).
				append("icn", icn).
				append("categoryCode", categoryCode).
				append("healthBenefitCode", healthBenefitCode).
				append("coveragePlanCode", coveragePlanCode).
				append("releaseControlNumber", releaseControlNumber);
	}
}
