package gov.va.med.esr.common.batchprocess;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.util.StringUtils;

/*
 * parses incoming files from CMS with successful mailing data
 * 
 * TODO : updataed
 * 
 */

public class HandbookMailingResponseReturnedByUSPSFileData extends 
           AbstractRawFileDataContainer  {
	/**
	 * 
	 */
	private static final long serialVersionUID = -1564589185245001470L;
	private String prodnum;
	private String uid;
	private String vpid;
	private String prepforname;
	private String addr1;
	private String addr2;
	private String city;
	private String state;
	private String zip;
    private String datemailed;
    private String datereturned;
    
	protected void buildToString(ToStringBuilder builder) {
		builder.append("prodnum", prodnum).append("uid", uid).append("vpid", vpid).
			append("prepforname", prepforname).append("addr1", addr1).append("addr2", addr2).
			append("city", city).append("state", state).append("zip", zip).
			append("datemailed", datemailed).append("datereturned", datereturned);
	}
	
    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow,
            ClassMapping classMapping) throws Exception
    {
    	int i = 0;
    	this.setProdNumText(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setUID(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setVPID(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setPrepforname(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setAddr1(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setAddr2(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setCity(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setState(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setZip(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setDatemailed(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setDatereturned(StringUtils.stripToNull(parsedRow.getString(i++)));    	
    }
    
	protected List validateData(){
		ArrayList errors = new ArrayList();
		if ( prodnum == null || prodnum.length() <= 0 ) {
			errors.add("Missing ProductId");
		}
		if ( uid == null || uid.length() <= 0 ) {
			errors.add("Missing UID");
		}
		if ( vpid == null || vpid.length() <= 0 ) {
			errors.add("Missing VPID");
		}
		if ( addr1 == null || addr1.length() <= 0 ) {
			errors.add("Missing addr1");
		}		
		if ( city == null || city.length() <= 0 ) {
			errors.add("Missing City");
		}		
		if ( state == null || state.length() <= 0 ) {
			errors.add("Missing State");
		}		
		if ( zip == null || zip.length() <= 0 ) {
			errors.add("Missing Zip");
		}		
		if ( datemailed == null || datemailed.length() <= 0 ) {
			errors.add("Missing Date Mailed");
		}
		if ( datereturned == null || datereturned.length() <= 0 ) {
			errors.add("Missing Date Returned");
		}
		return errors;
	}      
    
    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception
    {
        // no op as this class is used only for parsing data from a input file
        return null;
    }    
	
	public String getProdNumText() {
		return prodnum;
	}

	public void setProdNumText(String prodnum) {
		this.prodnum = prodnum;
	}

	
	public String getUID() {
		return uid;
	}

	public void setUID(String Uid) {
		this.uid = Uid;
	}

	public String getVPID() {
		return vpid;
	}

	public void setVPID(String Vpid) {
		this.vpid = Vpid;
	}

	public String getPrepforname() {
		return prepforname;
	}

	public void setPrepforname(String prepforname) {
		this.prepforname = prepforname;
	}

	public String getAddr1() {
		return addr1;
	}

	public void setAddr1(String addr1) {
		this.addr1 = addr1;
	}

	public String getAddr2() {
		return addr2;
	}

	public void setAddr2(String addr2) {
		this.addr2 = addr2;
	}	
	
	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}
	
	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}
	
	public String getDatereturned() {
		return datereturned;
	}

	public void setDatereturned(String retdate) {
		this.datereturned = retdate;
	}
	
	public String getDatemailed() {
		return datemailed;
	}

	public void setDatemailed(String datemailed) {
		this.datemailed = datemailed;
	}
		
}
