package gov.va.med.esr.common.batchprocess;


import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.util.StringUtils;

/*
 * parses incoming files from CMS with errors mailing data
 * 
 * TODO : 
 */

public class HandbookMailingResponseErrorFileData extends 
           AbstractRawFileDataContainer  {
	/**
	 * 
	 */
	private static final long serialVersionUID = -1564589185245001470L;
	private String prodnum;
	private String uid;
	private String vpid;
	private String failed;

    
	protected void buildToString(ToStringBuilder builder) {
		builder.append("prodnum", prodnum).append("uid", uid).append("vpid", vpid).
			append("failed", failed);
	}
	
    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow,
            ClassMapping classMapping) throws Exception
    {
    	int i = 0;
    	this.setProdNumText(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setUID(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setVPID(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setFailed(StringUtils.stripToNull(parsedRow.getString(i++)));
    	
    }

	protected List validateData(){
		ArrayList errors = new ArrayList();
		if ( prodnum == null || prodnum.length() <= 0 ) {
			errors.add("Missing ProductId");
		}
		if ( uid == null || uid.length() <= 0 ) {
			errors.add("Missing HandbookRequestId");
		}
		if ( vpid == null || vpid.length() <= 0 ) {
			errors.add("Missing ReleaseControlId");
		}
		if ( failed == null || failed.length() <= 0 ) {
			errors.add("Missing failed string");
		}
		return errors;
	}      
    
    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception
    {
        // no op as this class is used only for parsing data from a input file
        return null;
    }    
	
	public String getProdNumText() {
		return prodnum;
	}

	public void setProdNumText(String prodnum) {
		this.prodnum = prodnum;
	}

	
	public String getUID() {
		return uid;
	}

	public void setUID(String Uid) {
		this.uid = Uid;
	}

	public String getVPID() {
		return vpid;
	}

	public void setVPID(String Vpid) {
		this.vpid = Vpid;
	}

	public String getFailed() {
		return failed;
	}

	public void setFailed(String failed) {
		this.failed = failed;
	}

}
