package gov.va.med.esr.common.batchprocess;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import gov.va.med.fw.io.FileNameAppender;

/**
 * Appends a dynamic file name extension to the SSN verification file sent to
 * SSA.
 * 
 * @author Rajiv Patnaik Created on Mar 24, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class HandbookFileNameAppender implements FileNameAppender
{
    private String fileExtension;

    /**
     * The files are named as 
	 * CMS_DataExtract_timestamp.hbk
	 * Timestamp includes yyyymmddhhmmss
	 * For e.g. CMS_DataExtract_060120111653.hbk

     */
    public String getFileNameSuffix(Object obj)
    {
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(Calendar
                .getInstance().getTime());

        //Calendar returns AM = 0 and PM =1. So increment by 1
        //int timeSubmission = Calendar.getInstance().get(Calendar.AM_PM) + 1;

        return (date + fileExtension);
    }

     /**
     * @return Returns the fileExtension.
     */
    public String getFileExtension()
    {
        return fileExtension;
    }

    /**
     * @param fileExtension
     *            The fileExtension to set.
     */
    public void setFileExtension(String fileExtension)
    {
        this.fileExtension = fileExtension;
    }
}