package gov.va.med.esr.common.batchprocess;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * This contains data to write to a output file during the Request SSN verification Process
 * and contain data from the SSN Verification Process Presponse files.
 *   
 * @author Rajiv Patnaik
 * Created on Mar 6, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class HandbookData extends BatchProcessPersonIdentityTraits
{
    private static final long serialVersionUID = 6151448811095719638L; 
   
    private String equal = "="; 
    private String mailingPreference = "Q01=MAIL";
    private String versionNumber = "001";
    
    private String formNumber;
    private String fileCreateDate;
    private String uniqueIdentifier;    
    
    private String enrolleeIndicator;   
    
    //identiry trait information
    private String hbGender; //super
    private String hbPrefix; //super
    private String hbLastName; //super
    private String hbFirstName; //super
    private String hbMiddleName; //super
    private String hbSuffix; //super
    private String hbDateOfBirth;
    private String vpid;
    
    //address information
    private String addressLine1;
    private String addressLine2;
    private String addressLine3;
    private String city;
    private String state;
    private String country;
    private String zipCode;
    private String postalCode;
    private String county;
    private String province;
    private String email;
    private String badAddressIndicator;
    
    //enrollment information
    private String applicationDate;
    private String enrollmentDate;
    private String enrollmentEndDate;
    private String earliestEffDate; //earliest effective date of change
    private String recentEffDate; //most recent effective date of change
    private String enrollmentCategory;
    private String enrollmentStatus;
    private String enrollmentPriority;
    private String enrollmentSubPriority;
    private String primaryEligibilityCode;
    
    //service connected
    private String serviceConnected;
    private String serviceConnectedPercentage;
    private String ptIndicator;
    private String unemployableInd; 
    
    //monetarybenefit
    private String checkAmount;      
    private String vaPensionIndicator;
    private String aaStatus;
    private String houseBoundStatus;
    
    //incomeTest
    private String attributableIncome;
    private String mtStatus;
    private String rxCopay;
    private String hardshipEndDate;
    private String medicadeStatus;
    
    //preferred facility information
    private String preferedFacilities;
    
    //indicators
    private String purpleHeartIndicator;
    private String purpleHeartStatus;
    private String powIndicator;
    private String mohIndicator;
    
    //militaryServiceInformation
    private String combatVeteranEligStatus;
    private String CVEndDate;
    private String disabilityDischarge;
    private String disabilityRetirement;
    private String radiationExposureIndicator;
    private String radiationExposureMethod;
    private String shadIndicator;
    private String ntrIndicator;
    private String ntrVerificationStationNum;
    private String ntrVerificationMethod;
    private String agentOrange;
    private String agentOrangeLoc;
    private String swAsiaIndicator;
    private String catastrophicallyDisabledInd;
    private String receivingDisabilityComp;

	public String getMailingPreference() {
		return mailingPreference;
	}


	public void setMailingPreference(String mailingPreference) {
		this.mailingPreference = mailingPreference;
	}


	public String getAgentOrange() {
		return agentOrange;
	}


	public void setAgentOrange(String agentOrange) {
		this.agentOrange = "M11"+equal+agentOrange;
	}


	public String getAgentOrangeLoc() {
		return agentOrangeLoc;
	}


	public void setAgentOrangeLoc(String agentOrangeLoc) {
		this.agentOrangeLoc = "M12"+equal+agentOrangeLoc;
	}


	public String getCatastrophicallyDisabledInd() {
		return catastrophicallyDisabledInd;
	}


	public void setCatastrophicallyDisabledInd(String catastrophicallyDisabledInd) {
		this.catastrophicallyDisabledInd = "M14"+equal+catastrophicallyDisabledInd;
	}


	public String getNtrIndicator() {
		return ntrIndicator;
	}


	public void setNtrIndicator(String ntrIndicator) {
		this.ntrIndicator = "M08"+equal+ntrIndicator;
	}


	public String getNtrVerificationMethod() {
		return ntrVerificationMethod;
	}


	public void setNtrVerificationMethod(String ntrVerificationMethod) {
		this.ntrVerificationMethod = "M10"+equal+ntrVerificationMethod;
	}


	public String getNtrVerificationStationNum() {
		return ntrVerificationStationNum;
	}


	public void setNtrVerificationStationNum(String ntrVerificationStationNum) {
		this.ntrVerificationStationNum = "M09"+equal+ntrVerificationStationNum;
	}


	public String getRadiationExposureIndicator() {
		return radiationExposureIndicator;
	}


	public void setRadiationExposureIndicator(String radiationExposureIndicator) {
		this.radiationExposureIndicator = "M05"+equal+radiationExposureIndicator;
	}


	public String getRadiationExposureMethod() {
		return radiationExposureMethod;
	}


	public void setRadiationExposureMethod(String radiationExposureMethod) {
		this.radiationExposureMethod = "M06"+equal+radiationExposureMethod;
	}


	public String getReceivingDisabilityComp() {
		return receivingDisabilityComp;
	}


	public void setReceivingDisabilityComp(String receivingDisabilityComp) {
		this.receivingDisabilityComp = "N05"+equal+receivingDisabilityComp;
	}


	public String getShadIndicator() {
		return shadIndicator;
	}


	public void setShadIndicator(String shadIndicator) {
		this.shadIndicator = "M07"+equal+shadIndicator;
	}


	public String getSwAsiaIndicator() {
		return swAsiaIndicator;
	}


	public void setSwAsiaIndicator(String swAsiaIndicator) {
		this.swAsiaIndicator = "M13"+equal+swAsiaIndicator;
	}


	public String getCombatVeteranEligStatus() {
		return combatVeteranEligStatus;
	}


	public void setCombatVeteranEligStatus(String combatVeteranEligStatus) {
		this.combatVeteranEligStatus = "M01"+equal+combatVeteranEligStatus;
	}


	public String getCVEndDate() {
		return CVEndDate;
	}


	public void setCVEndDate(String endDate) {
		CVEndDate = "M02"+equal+endDate;
	}


	public String getDisabilityDischarge() {
		return disabilityDischarge;
	}


	public void setDisabilityDischarge(String disabilityDischarge) {
		this.disabilityDischarge = "M03"+equal+disabilityDischarge;
	}


	public String getDisabilityRetirement() {
		return disabilityRetirement;
	}


	public void setDisabilityRetirement(String disabilityRetirement) {
		this.disabilityRetirement = "M04"+equal+disabilityRetirement;
	}


	public String getMedicadeStatus() {
		return medicadeStatus;
	}


	public void setMedicadeStatus(String medicadeStatus) {
		this.medicadeStatus = "G07"+equal+medicadeStatus;
	}


	public String getHardshipEndDate() {
		return hardshipEndDate;
	}


	public void setHardshipEndDate(String hardshipEndDate) {
		this.hardshipEndDate = "G06"+equal+hardshipEndDate;
	}


	public String getRxCopay() {
		return rxCopay;
	}


	public void setRxCopay(String rxCopay) {
		this.rxCopay = "G05"+equal+rxCopay;
	}


	public String getMtStatus() {
		return mtStatus;
	}


	public void setMtStatus(String mtStatus) {
		this.mtStatus = "G04"+equal+mtStatus;
	}


	public String getPrimaryEligibilityCode() {
		return primaryEligibilityCode;
	}


	public void setPrimaryEligibilityCode(String primaryEligibilityCode) {
		this.primaryEligibilityCode = "G03"+equal+primaryEligibilityCode;
	}


	public String getMohIndicator() {
		return mohIndicator;
	}


	public void setMohIndicator(String mohIndicator) {
		this.mohIndicator = "F10"+equal+mohIndicator;
	}


	public String getPowIndicator() {
		return powIndicator;
	}


	public void setPowIndicator(String powIndicator) {
		this.powIndicator = "F09"+equal+powIndicator;
	}


	public String getPurpleHeartIndicator() {
		return purpleHeartIndicator;
	}


	public void setPurpleHeartIndicator(String purpleHeartIndicator) {
		this.purpleHeartIndicator = "F07"+equal+purpleHeartIndicator;
	}


	public String getPurpleHeartStatus() {
		return purpleHeartStatus;
	}


	public void setPurpleHeartStatus(String purpleHeartStatus) {
		this.purpleHeartStatus = "F08"+equal+purpleHeartStatus;
	}


	public String getAttributableIncome() {
		return attributableIncome;
	}


	public void setAttributableIncome(String attributableIncome) {
		this.attributableIncome = "N06"+equal+attributableIncome;
	}


	public String getAaStatus() {
		return aaStatus;
	}


	public void setAaStatus(String aaStatus) {
		this.aaStatus = "G01"+equal+aaStatus;
	}


	public String getHouseBoundStatus() {
		return houseBoundStatus;
	}


	public void setHouseBoundStatus(String houseBoundStatus) {
		this.houseBoundStatus = "G02"+equal+houseBoundStatus;
	}


	public String getVaPensionIndicator() {
		return vaPensionIndicator;
	}


	public void setVaPensionIndicator(String vaPensionIndicator) {
		this.vaPensionIndicator = "F06"+equal+vaPensionIndicator;
	}


	public String getCheckAmount() {
		return checkAmount;
	}


	public void setCheckAmount(String checkAmount) {
		this.checkAmount = "F03"+equal+checkAmount;
	}


	public String getPtIndicator() {
		return ptIndicator;
	}


	public void setPtIndicator(String ptIndicator) {
		this.ptIndicator = "F05"+equal+ptIndicator;
	}


	public String getServiceConnected() {
		return serviceConnected;
	}


	public void setServiceConnected(String serviceConnected) {
		this.serviceConnected = "F01"+equal+serviceConnected;
	}


	public String getServiceConnectedPercentage() {
		return serviceConnectedPercentage;
	}


	public void setServiceConnectedPercentage(String serviceConnectedPercentage) {
		this.serviceConnectedPercentage = "F02"+equal+serviceConnectedPercentage;
	}


	public String getUnemployableInd() {
		return unemployableInd;
	}


	public void setUnemployableInd(String unemployableInd) {
		this.unemployableInd = "F04"+equal+unemployableInd;
	}


	public String getApplicationDate() {
		return applicationDate;
	}


	public void setApplicationDate(String applicationDate) {
		this.applicationDate = "E01"+equal+applicationDate;
	}


	public String getEarliestEffDate() {
		return earliestEffDate;
	}


	public void setEarliestEffDate(String earliestEffDate) {
		this.earliestEffDate = "E04"+equal+earliestEffDate;
	}


	public String getEnrollmentCategory() {
		return enrollmentCategory;
	}


	public void setEnrollmentCategory(String enrollmentCategory) {
		this.enrollmentCategory = "E06"+equal+enrollmentCategory;
	}


	public String getEnrollmentDate() {
		return enrollmentDate;
	}


	public void setEnrollmentDate(String enrollmentDate) {
		this.enrollmentDate = "E02"+equal+enrollmentDate;
	}


	public String getEnrollmentEndDate() {
		return enrollmentEndDate;
	}


	public void setEnrollmentEndDate(String enrollmentEndDate) {
		this.enrollmentEndDate = "E03"+equal+enrollmentEndDate;
	}


	public String getEnrollmentPriority() {
		return enrollmentPriority;
	}


	public void setEnrollmentPriority(String enrollmentPriority) {
		this.enrollmentPriority = "E08"+equal+enrollmentPriority;
	}


	public String getEnrollmentStatus() {
		return enrollmentStatus;
	}


	public void setEnrollmentStatus(String enrollmentStatus) {
		this.enrollmentStatus = "E07"+equal+enrollmentStatus;
	}


	public String getEnrollmentSubPriority() {
		return enrollmentSubPriority;
	}


	public void setEnrollmentSubPriority(String enrollmentSubPriority) {
		this.enrollmentSubPriority = "E09"+equal+enrollmentSubPriority;
	}


	public String getRecentEffDate() {
		return recentEffDate;
	}


	public void setRecentEffDate(String recentEffDate) {
		this.recentEffDate = "E05"+equal+recentEffDate;
	}


	public String getPreferedFacilities() {
		return preferedFacilities;
	}


	public void setPreferedFacilities(String preferedFacilities) {
		this.preferedFacilities = "P01"+equal+preferedFacilities;
	}


	public String getBadAddressIndicator() {
		return badAddressIndicator;
	}


	public void setBadAddressIndicator(String badAddressIndicator) {
		this.badAddressIndicator = "B11"+equal+badAddressIndicator;
	}


	public String getEmail() {
		return email;
	}


	public void setEmail(String email) {
		this.email = "B10"+equal+email;
	}


	public String getAddressLine1() {
		return addressLine1;
	}


	public void setAddressLine1(String addressLine1) {
		this.addressLine1 = "B01"+equal+addressLine1;
	}


	public String getAddressLine2() {
		return addressLine2;
	}


	public void setAddressLine2(String addressLine2) {
		this.addressLine2 = "B02"+equal+addressLine2;
	}


	public String getAddressLine3() {
		return addressLine3;
	}


	public void setAddressLine3(String addressLine3) {
		this.addressLine3 = "B03"+equal+addressLine3;
	}


	public String getCity() {
		return city;
	}


	public void setCity(String city) {
		this.city = "B04"+equal+city;
	}


	public String getCountry() {
		return country;
	}


	public void setCountry(String country) {
		this.country = "B06"+equal+country;
	}


	public String getCounty() {
		return county;
	}


	public void setCounty(String county) {
		this.county = "B08"+equal+county;
	}


	public String getPostalCode() {
		return postalCode;
	}


	public void setPostalCode(String postalCode) {
		this.postalCode = "B07"+equal+postalCode;
	}


	public String getProvince() {
		return province;
	}


	public void setProvince(String province) {
		this.province = "B09"+equal+province;
	}


	public String getState() {
		return state;
	}


	public void setState(String state) {
		this.state = "B05"+equal+state;
	}


	public String getZipCode() {
		return zipCode;
	}


	public void setZipCode(String zipCode) {
		this.zipCode = "B06"+equal+zipCode;
	}


	public String getVpid() {
		return vpid;
	}


	public void setVpid(String vpid) {
		this.vpid = "A15"+equal+vpid;		
	}


	public String getHbDateOfBirth() {
		return hbDateOfBirth;
	}


	public void setHbDateOfBirth(String hbDOB) {
		this.hbDateOfBirth = "N03"+equal+hbDOB;		
	}


	public String getHbFirstName() {
		return hbFirstName;
	}


	public void setHbFirstName(String hbFirstName) {
		this.hbFirstName = "A02"+equal+hbFirstName;						
		super.setFirstName(getHbFirstName());
	}


	public String getHbLastName() {
		return hbLastName;
	}


	public void setHbLastName(String hbLastName) {
		this.hbLastName = "A01"+equal+hbLastName;					
		super.setLastName(getHbLastName());
	}


	public String getHbMiddleName() {
		return hbMiddleName;
	}


	public void setHbMiddleName(String hbMiddleName) {
		this.hbMiddleName = "A03"+equal+hbMiddleName;			
		super.setMiddleInitial(getHbMiddleName());
	}


	public String getHbPrefix() {
		return hbPrefix;
	}


	public void setHbPrefix(String hbPrefix) {
		this.hbPrefix = "A00"+equal+hbPrefix;		
		super.setPrefix(getHbPrefix());
	}


	public String getHbSuffix() {
		return hbSuffix;
	}


	public void setHbSuffix(String hbSuffix) {		
		this.hbSuffix = "A04"+equal+hbSuffix;
		super.setSuffix(getHbSuffix());
	}


	public String getHbGender() {
		return hbGender;
	}


	public void setHbGender(String hbGender) {
		this.hbGender = "N02"+equal+hbGender;
		super.setGender(getHbGender());
	}


	public String getEnrolleeIndicator() {
		return enrolleeIndicator;
	}


	public void setEnrolleeIndicator(String enrolleeIndicator) {
		this.enrolleeIndicator = "N01"+equal+enrolleeIndicator;
	}


	public String getFileCreateDate() {
		return fileCreateDate;
	}


	public void setFileCreateDate(String fileCreateDate) {
		this.fileCreateDate = fileCreateDate;
	}


	public String getFormNumber() {
		return formNumber;
	}


	public void setFormNumber(String formNumber) {
		this.formNumber = formNumber;
	}


	public String getUniqueIdentifier() {
		return uniqueIdentifier;
	}


	public void setUniqueIdentifier(String uniqueIdentifier) {
		this.uniqueIdentifier = "Q02"+equal+uniqueIdentifier;
	}


	public String getVersionNumber() {
		return versionNumber;
	}


	public void setVersionNumber(String versionNumber) {
		this.versionNumber = versionNumber;
	}


	protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);

        /*builder.append("entryCode", this.entryCode);
        builder.append("processingCode", this.processingCode);
        builder.append("incomeYear", this.incomeYear);
        builder.append("HECInternalID", this.HECInternalID);
        builder.append("spouseCode", this.spouseCode);
        builder.append("verificationCode", this.verificationCode);
        builder.append("requestCode", this.requestCode);
        builder.append("ssnId", this.ssnId);
        builder.append("vpidValue", this.vpidValue);
        builder.append("personId", this.personId);*/
        
    }

	  
}
