package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;


//RTC WI 378052
public class GenerateZ05Process extends AbstractDataFileSingleRowIncrementProcess {
	private TriggerRouter triggerRouter;

	protected boolean processDataRecord(
			DataFileProcessExecutionContext context, Object bean) {

		boolean success = false;

		try {
			PersonIdFileData dataRecord = (PersonIdFileData) bean;
	        PersonIdEntityKey key = CommonEntityKeyFactory.createPersonIdEntityKey(dataRecord.getPersonId());

    		getTriggerRouter().processTriggerEvent(getTriggerEvent(key));

    		success = true;
		} catch (Exception e) {
			logger.error("Unknown exception in generate Z05 process", e);
		}

		// Update statistics more frequently than once per batch (default size 500)
		if (context.getProcessStatistics().isTotalNumberMod(
				DEFAULT_JOB_RESULT_UPDATE_INTERVAL))
			this.updateJobResult(context);

		return success;
	}

	private TriggerEvent getTriggerEvent(PersonEntityKey key)
	{
		PersonTriggerEvent triggerEvent = new PersonTriggerEvent(PersonTrigger.DestinationType.MESSAGING,
                PersonTrigger.TargetType.VISTA, PersonTrigger.DispatchType.NOTIFY,  PersonTrigger.DataType.ADDRESS);
		triggerEvent.setPersonId(key);
		return triggerEvent;

	}


	public TriggerRouter getTriggerRouter() {
		return triggerRouter;
	}


	public void setTriggerRouter(TriggerRouter triggerRouter) {
		this.triggerRouter = triggerRouter;
	}
}

