package gov.va.med.esr.common.batchprocess;

import java.math.BigDecimal;
import java.util.List;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;

/**
 * CCR13395
 * Inserts records into ssn Verification queue identified for cleanup
 * Input file is list of veteran person_id's
 * that were never queued for verification during initial enrollment determination
 *
 * Created Nov 7, 2014
 * @author DNS   faulkj
 */
public class GenerateSsnVerificationProcess extends
AbstractDataFileIncrementalProcess {

	private PersonHelperService personHelperService = null;
	private PersonService personService = null;

	@Override
	public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {

        for ( int i=0; acquiredData != null && i< acquiredData.size(); i++)
        {

        	PersonIdFileData dataRecord = (PersonIdFileData) acquiredData.get(i);

        	try {

	        	PersonIdEntityKey personKey = CommonEntityKeyFactory.createPersonIdEntityKey(dataRecord.getPersonId());
	        	Person incoming = this.getPersonService().getPerson(personKey);

                if (logger.isDebugEnabled())
                       logger.debug("Generate SSN Verification - Processing person ID  " + incoming.getPersonEntityKey().getKeyValueAsString());

                //insert to SSN Verification queue
                this.getPersonHelperService().addToSSNVerificationQueue(incoming);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();


            } catch (Exception e) {
                if (logger.isErrorEnabled())
                   logger.error("Error during GenerateSSNVerificationProcess for person ID " + dataRecord.getPersonId(), e);

                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            finally
            {
                // Check if we need to update the job result
                if(shouldUpdateJobResult(context))
                        updateJobResult(context);

                if ( isInterrupted(context))
                {
                    break;
                }
            }

        }

	}
	public PersonHelperService getPersonHelperService() {
		return personHelperService;
	}
	public void setPersonHelperService(PersonHelperService personHelperService) {
		this.personHelperService = personHelperService;
	}

	public PersonService getPersonService() {
		return personService;
	}
	public void setPersonService(PersonService personService) {
		this.personService = personService;
	}
}
