package gov.va.med.esr.common.batchprocess;

import java.math.BigDecimal;
import java.util.List;

import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;

public class GenerateMsdsQueryProcess extends
AbstractDataFileIncrementalProcess {

	private MessagingService messagingService = null;
	private PersonService personService = null;
	
	@Override
	public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
		if (logger.isDebugEnabled())
        {
            int listSize = 0;
            if ( acquiredData != null ) listSize = acquiredData.size();
            
            logger.error("Processing VPID  " + listSize);                       
            
        }
        
        for ( int i=0; acquiredData != null && i< acquiredData.size(); i++)
        {
            VPIDFileData dataRecord = (VPIDFileData) acquiredData.get(i);
            String personIdinString = dataRecord.getVpid();        

            try {
                
                BigDecimal personId = new BigDecimal(personIdinString);
                PersonEntityKey key = new PersonIdEntityKeyImpl(personId);
                                
                if (logger.isDebugEnabled())
                       logger.error("Processing person ID  " + dataRecord.getVpid());
                
                /*send query to broker*/                                
                this.getMessagingService().processTriggerBroker(getPersonService().getPerson(key));
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();                
                
                
            } catch (Exception e) {
                if (logger.isErrorEnabled())
                   logger.error("Error during continous Enrollment clean up process for person ID " + dataRecord.getVpid(), e);
                    
                context.getProcessStatistics().incrementNumberOfErrorRecords();
            }
            finally
            {
                // Check if we need to update the job result
                if(shouldUpdateJobResult(context))
                        updateJobResult(context);
                
                if ( isInterrupted(context))
                {
                    break;
                }
            }
            
        }
		
	}
	public MessagingService getMessagingService() {
		return messagingService;
	}
	public void setMessagingService(MessagingService messagingService) {
		this.messagingService = messagingService;
	}
	
	public PersonService getPersonService() {
		return personService;
	}
	public void setPersonService(PersonService personService) {
		this.personService = personService;
	}
}
