/********************************************************************
 * Copyright  2008 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.batchprocess.DataQueryProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;

/**
 * Custom ProcessStatistics class for ExpireMeansTest.  Provides 
 * tracking of the number of records that are not subject to means test.
 * 
 * Created May 29, 2008 1:22:36 PM
 * @author DNS   GALLAS
 */
public class ExpireMeansTestProcessStatistics extends DataQueryProcessStatistics {
    
    private static final long serialVersionUID = -8377624362314423898L;
    
    private int numberOfNotSubjectToMeansTestRecords;
    
    /**
     * @param numberOfNotSubjectToMeansTestRecords The numberOfNotSubjectToMeansTestRecords to set.
     */
    public void setNumberOfNotSubjectToMeansTestRecords(int numberOfNotSubjectToMeansTestRecords) {
        this.numberOfNotSubjectToMeansTestRecords = numberOfNotSubjectToMeansTestRecords;
    }
    
    /**
     * @return Returns the numberOfNotSubjectToMeansTestRecords.
     */
    public int getNumberOfNotSubjectToMeansTestRecords() {
        return numberOfNotSubjectToMeansTestRecords;
    }
    
    public void incrementNumberOfNotSubjectToMeansTestRecords() {
        incrementNumberOfNotSubjectToMeansTestRecords(1);
    }
    
    public void incrementNumberOfNotSubjectToMeansTestRecords(int recordsCount) {
        numberOfNotSubjectToMeansTestRecords += recordsCount;
        incrementNumberOfTotalRecords(recordsCount);
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("numberOfNotSubjectToMeansTestRecords", getNumberOfNotSubjectToMeansTestRecords());
    }
    
    protected void appendStats(ProcessStatistics stats) {
        ExpireMeansTestProcessStatistics incoming = (ExpireMeansTestProcessStatistics) stats;
        this.incrementNumberOfNotSubjectToMeansTestRecords(incoming.getNumberOfNotSubjectToMeansTestRecords());
    }
}
