/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess;


import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.HL7ProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;

import java.sql.Types;
import java.sql.CallableStatement;
import java.sql.SQLException;
import org.hibernate.Session;

import java.util.ArrayList;
import java.util.List;


/**
 * Batch Process to trigger E&E and Z10's when the future dated test become effective.
 * 
 * @author DNS   MANSOG
 */
public class DeleteHL7Process extends AbstractDataQueryProcess {	

	/**
	 * @see gov.va.med.fw.batchprocess.AbstractDataProcess#processData(gov.va.med.fw.batchprocess.DataProcessExecutionContext,
	 *      java.util.List)
	 */
	protected void processData(DataProcessExecutionContext context, List acquiredData) {
		if(logger.isInfoEnabled())
			logger.info("DeleteHL7Process: Query result Size="+(acquiredData == null ? 0 : acquiredData.size()));
		
		if (acquiredData == null)			
			return;
		
		for (int i = 0; i < acquiredData.size(); i++) {
			
			HL7ProcessStatistics hl7stats = (HL7ProcessStatistics) context.getProcessStatistics();
			hl7stats.incrementNumberOfSuccessfulRecords();
			hl7stats.setSpReturnedStatus((String)acquiredData.get(i));			
			
			logger.info("This is the returned result from the stored procedure for item " + i); // acquiredData.get(i));			
		}
		
		if(logger.isDebugEnabled()) {
			logger.debug("DeleteHL7Process: Processing complete.");
			logger.debug("DeleteHL7Process: Successful records count = "+context.getProcessStatistics().getNumberOfSuccessfulRecords());
			logger.debug("DeleteHL7Process: Failure records count ="+context.getProcessStatistics().getNumberOfErrorRecords());
		}
	}
	
//	 subclasses can override
    protected List executeQuery(DataQueryProcessExecutionContext context) throws Exception {    	
    	List results = new ArrayList();
    	Object args = context.getExecutionArguments();
    	int incomingSpArg;
    	int defaultArg = 1;   
    	final int spArg;
    	if(args != null){
    		incomingSpArg = Integer.parseInt((String)args);    		
    	}
    	else{
    		incomingSpArg = defaultArg;
    	}    	
    	
    	if(context.isInterrupted()){
    		incomingSpArg = 0;    		  		
    	}
    	spArg = incomingSpArg;
    	
    	AbstractDAOAction callback = new AbstractDAOAction() { 
			public List execute(Session session) throws DAOException {			
				List<String> results = new ArrayList();
				try {
					CallableStatement call = session.connection().prepareCall("{? = call ADR.Hl7_Archive_Pkg.Hl7_Delete_Control(?)}");
					call.registerOutParameter(1, Types.VARCHAR);					
					call.setInt(2,spArg);				
					call.execute();
					String returnedResult = (String)call.getString(1);
					results.add(returnedResult);
           		} catch (SQLException ex) {
					throw new DAOException(
							"Failed to execute prepare statement: ", ex);
				}	
           		return results;
			}
 		};
    	
 		return results = (List) getDao().execute(callback);
    	           
    }	
    
    
    public void afterPropertiesSet() {
		super.afterPropertiesSet();		
	}
    
    protected ProcessStatistics createProcessStatistics() {
        return new HL7ProcessStatistics();
    }
}
