/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.batchprocess;



import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.fw.util.StringUtils;

/**
 * Initial javadoc for class DateFieldTransformer.
 * TODO - Add content here
 * 
 * Created Mar 31, 2006 3:51:41 PM
 * @author DNS   BOHMEG
 */
public class DateFieldTransformer extends
		gov.va.med.fw.io.writer.DateFieldTransformer {
	
	private static final String LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT="yyyy";
	private static final String UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT="YYYY";
	private static final String LOWER_CASE_TWO_DIGIT_YEAR_FORMAT="yy";
	private static final String UPPER_CASE_TWO_DIGIT_YEAR_FORMAT="YY";
	private static final String LOWER_CASE_MONTH_FORMAT="mm";
	private static final String UPPER_CASE_MONTH_FORMAT="MM";
	private static final String LOWER_CASE_DAY_FORMAT="dd";
	private static final String UPPER_CASE_DAY_FORMAT="DD";
	
	private boolean formatImprecise=false;
	
	public Object transformData(String fieldName, Object data) throws Exception {
		Object transformedVal = data;
		// check first for ImpreciseDate
		if(data != null && data instanceof ImpreciseDate) {
			ImpreciseDate date = (ImpreciseDate) data;
			if(date.isPrecise())
				transformedVal = super.transformData(fieldName, date.getDate());
			else if(formatImprecise){
				transformedVal=formatImpreciseDate(date);
			}
			else {
				String transformedValStr = date.getString();
				transformedVal = transformedValStr;			
			}
		} else {
			transformedVal = super.transformData(fieldName, data);
		}		
		return transformedVal;
	}
	/**
	 * This method formats the imprecise date. If month or day is null pads with Zeros.
	 * @param date
	 * @return
	 */
	private String formatImpreciseDate(ImpreciseDate date)
	{
		String defaultFormat=getDateFormat();
		String formattedDate=defaultFormat;
		if(date.getString()!=null&& date.getString().length()>=4)
		{
			String string = date.getString();
	        String year = string.substring(0, 4);
	        String month = date.isMonthPrecise() ? string.substring(4, 6) : "00";
	        String day = date.isDayPrecise() ? string.substring(6, 8) : "00";
	        
	        if(StringUtils.contains(formattedDate,LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT))
	        	formattedDate=StringUtils.replace(formattedDate, LOWER_CASE_FOUR_DIGIT_YEAR_FORMAT, year);
			else if(StringUtils.contains(formattedDate,UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT))
				formattedDate=StringUtils.replace(formattedDate, UPPER_CASE_FOUR_DIGIT_YEAR_FORMAT, year);
			else if(StringUtils.contains(formattedDate,UPPER_CASE_TWO_DIGIT_YEAR_FORMAT))
				formattedDate=StringUtils.replace(formattedDate, UPPER_CASE_TWO_DIGIT_YEAR_FORMAT, year.substring(2, 4));
			else if(StringUtils.contains(formattedDate,LOWER_CASE_TWO_DIGIT_YEAR_FORMAT))
				formattedDate=StringUtils.replace(formattedDate, LOWER_CASE_TWO_DIGIT_YEAR_FORMAT, year.substring(2, 4));
	        	
	        if (month != null)
	        {
	        	if(StringUtils.contains(formattedDate,UPPER_CASE_MONTH_FORMAT))
	        		formattedDate=StringUtils.replace(formattedDate, UPPER_CASE_MONTH_FORMAT, month);
				else if (StringUtils.contains(formattedDate,LOWER_CASE_MONTH_FORMAT))
					formattedDate=StringUtils.replace(formattedDate, LOWER_CASE_MONTH_FORMAT, month);
	        }     
	        	
            if (day != null)
            {
            	if(StringUtils.contains(formattedDate,UPPER_CASE_DAY_FORMAT))
            		formattedDate=StringUtils.replace(formattedDate, UPPER_CASE_DAY_FORMAT, day);
				else if (StringUtils.contains(formattedDate,LOWER_CASE_DAY_FORMAT))
					formattedDate=StringUtils.replace(formattedDate, LOWER_CASE_DAY_FORMAT, day);
            }            	        
		}
		
		return formattedDate;
	}
	public boolean isFormatImprecise() {
		return formatImprecise;
	}
	public void setFormatImprecise(boolean formatImprecise) {
		this.formatImprecise = formatImprecise;
	}
	
}
