package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.comms.CommsImportStatistics;
import gov.va.med.fw.batchprocess.AbstractLegacyDataProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.service.ServiceException;

public class CmsHandleMailingResponseProcess extends AbstractLegacyDataProcess {

	protected void executeProcess(DataProcessExecutionContext context)
			throws Exception {
		try {
			CmsImportProcess proc = (CmsImportProcess) getComponent("cmsImportProcess");
			CommsImportStatistics stat = proc.execute(null);
			if (stat != null) {
				logger.info("Error File Processed count = "
						+ stat.getErrorFileProcessedCount());
				logger.info("Error File Failed    count = "
						+ stat.getErrorFileFailedCount());

				logger.info("Rejected File Processed count = "
						+ stat.getRejectFileProcessedCount());
				logger.info("Rejected File Failed    count = "
						+ stat.getRejectFileFailedCount());

				logger.info("Mailed File Processed count = "
						+ stat.getMailedFileProcessedCount());
				logger.info("Mailed File Failed    count = "
						+ stat.getMailedFileFailedCount());

				context.getProcessStatistics().setNumberOfTotalRecords(
						stat.getErrorFileProcessedCount()
								+ stat.getErrorFileFailedCount()
								+ stat.getRejectFileProcessedCount()
								+ stat.getRejectFileFailedCount()
								+ stat.getMailedFileProcessedCount()
								+ stat.getMailedFileFailedCount()
								+ stat.getReturnedMailFileProcessedCount());
				context.getProcessStatistics().setNumberOfErrorRecords(
						stat.getErrorFileFailedCount()
								+ stat.getRejectFileFailedCount()
								+ stat.getMailedFileFailedCount());
				context.getProcessStatistics().setNumberOfSuccessfulRecords(
						stat.getErrorFileProcessedCount()
								+ stat.getRejectFileProcessedCount()
								+ stat.getMailedFileProcessedCount()
								+ stat.getReturnedMailFileProcessedCount());
			}
		} catch (Exception e) {
			logger.error("#### Can not execute CmsImportProcess!!!", e);
			throw new ServiceException(e);
		}
	}

}
