package gov.va.med.esr.common.batchprocess;

import java.io.Serializable;

import gov.va.med.esr.common.model.comms.AacLetterRequest;
import gov.va.med.esr.common.persistent.comms.AacLetterRequestDAO;
import gov.va.med.esr.common.persistent.comms.CommsLogEntryDAO;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.esr.common.persistent.comms.CommsTransLogDAO;
import gov.va.med.esr.common.persistent.comms.ExportFileDAO;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.writer.FormattedFileWriter;


/**
 * Export command dedicated to CMS targeted letters
 * 
 * @author DNS   ruizc
 *
 */
public interface CmsExportCommand extends Serializable {
	public CommsExportStatistics execute(String[] args,
			DataProcessExecutionContext context,
			InitiateCMSLetterExportProcess process) throws Exception;

	public void executeSingle(DataProcessExecutionContext context,
			InitiateCMSLetterExportProcess process, AacLetterRequest request,
			CommsExportStatistics stats, String aacExtractId) throws Exception;

	/**
	 * @return Returns the commsLogDAO.
	 */
	public CommsLogEntryDAO getCommsLogDAO();

	/**
	 * @param commsLogDAO
	 *            The commsLogDAO to set.
	 */
	public void setCommsLogDAO(CommsLogEntryDAO commsLogDAO);

	/**
	 * @return Returns the requestDAO.
	 */
	public AacLetterRequestDAO getRequestDAO();

	/**
	 * @param requestDAO
	 *            The requestDAO to set.
	 */
	public void setRequestDAO(AacLetterRequestDAO requestDAO);

	/**
	 * @return Returns the transDAO.
	 */
	public CommsTransLogDAO getTransDAO();

	/**
	 * @param transDAO
	 *            The transDAO to set.
	 */
	public void setTransDAO(CommsTransLogDAO transDAO);

	/**
	 * @return Returns the fileDAO.
	 */
	public ExportFileDAO getFileDAO();

	/**
	 * @param fileDAO
	 *            The fileDAO to set.
	 */
	public void setFileDAO(ExportFileDAO fileDAO);

	/**
	 * @return Returns the eligibilityEnrollmentService.
	 */
	public EligibilityEnrollmentService getEligibilityEnrollmentService();

	/**
	 * @param eligibilityEnrollmentService
	 *            The eligibilityEnrollmentService to set.
	 */
	public void setEligibilityEnrollmentService(
			EligibilityEnrollmentService eligibilityEnrollmentService);

	/**
	 * @return Returns the templateDAO.
	 */
	public CommsTemplateDAO getTemplateDAO();

	/**
	 * @param templateDAO
	 *            The templateDAO to set.
	 */
	public void setTemplateDAO(CommsTemplateDAO templateDAO);

	/**
	 * @return Returns the personHelperService.
	 */
	public PersonHelperService getPersonHelperService();

	/**
	 * @param personHelperService
	 *            The personHelperService to set.
	 */
	public void setPersonHelperService(PersonHelperService personHelperService);

	public int getBatchSize();

	public void setBatchSize(int batchSize);

	public FormattedFileWriter getFileWriter();

	public void setFileWriter(FormattedFileWriter fileWriter);

}
