package gov.va.med.esr.common.batchprocess;

import java.math.BigDecimal;
import java.util.List;

import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.fw.batchprocess.AbstractDataFileIncrementalProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.esr.service.ClinicalDeterminationService;

/**
 * One time process to clean-up income tests where veteran has Cd.
 * 
 * @author DNS   ruizc
 *
 */
public class CdVeteranCleanupProcess extends AbstractDataFileIncrementalProcess {
	 
	private ClinicalDeterminationService clinicalDeterminationService = null;
	
	public void processDataRecords(DataFileProcessExecutionContext context,
			List acquiredData) {
        if (logger.isDebugEnabled()) {
			int listSize = 0;
			if (acquiredData != null)
				listSize = acquiredData.size();

			logger.error("Processing VPID  " + listSize);

		}

		for (int i = 0; acquiredData != null && i < acquiredData.size(); i++) {
			VPIDFileData dataRecord = (VPIDFileData) acquiredData.get(i);
			String personIdinString = dataRecord.getVpid();

			try {

				BigDecimal personId = new BigDecimal(personIdinString);

				if (logger.isDebugEnabled())
					logger.error("Processing person ID  "
							+ dataRecord.getVpid());

				this.getClinicalDeterminationService().processCdForCleanup(
						new PersonIdEntityKeyImpl(personId));
				context.getProcessStatistics()
						.incrementNumberOfSuccessfulRecords();

			} catch (Exception e) {
				if (logger.isErrorEnabled())
					logger.error(
							"Error during Cd Veteran clean up process for person ID "
									+ dataRecord.getVpid(), e);

				context.getProcessStatistics().incrementNumberOfErrorRecords();
			} finally {
				// Check if we need to update the job result
				if (shouldUpdateJobResult(context))
					updateJobResult(context);

				if (isInterrupted(context)) {
					break;
				}
			}
		}

	}

	/**
	 * @return the clinicalDeterminationService
	 */
	public ClinicalDeterminationService getClinicalDeterminationService() {
		return clinicalDeterminationService;
	}

	/**
	 * @param clinicalDeterminationService the clinicalDeterminationService to set
	 */
	public void setClinicalDeterminationService(
			ClinicalDeterminationService clinicalDeterminationService) {
		this.clinicalDeterminationService = clinicalDeterminationService;
	}
    
}
