package gov.va.med.esr.common.batchprocess;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.batchprocess.DataQueryProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;

/**
 * A class to collect statistics for CD conversion job 
 * 
 * @author DNS   chenj2
 *
 */
public class CDConversionStatistics extends DataQueryProcessStatistics {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3637158575680115090L;

	private static final String NUMBER_NOT_CONVERTED= "numberNotConverted";	
	
	private int numberNotConverted;	
	
	
	protected void appendStats(ProcessStatistics stats) {

		CDConversionStatistics incoming = (CDConversionStatistics) stats;
		this.incrementNumberNotConverted(incoming.getNumberNotConverted());
	}

	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		
		builder.append(NUMBER_NOT_CONVERTED, numberNotConverted);
	}

	public int getNumberNotConverted() {
		return numberNotConverted;
	}

	public void setNumberNotConverted(
			int numberNotConverted) {
		this.numberNotConverted = numberNotConverted;
	}

	
	public void incrementNumberNotConverted(int count) {
		this.numberNotConverted += count;
	}

	public void incrementNumberNotConverted() {
		incrementNumberNotConverted(1);
	}

}
