package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;

import java.io.Serializable;

/**
 * A class to store the appointment conversion results
 * 
 * @author DNS   ruizc
 *
 */
public class AppointmentConversionResult implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8023981022879845155L;

	private int numberWithCancelledDeclinedStatus = 0;	

	private int numberWithRejectedEnrollmentStatus = 0;	

	public void incrementCount(EnrollmentDetermination enrollment){
		String status = enrollment != null ? enrollment.getEnrollmentStatus().getCode() : null;
		if (EnrollmentStatus.CODE_REJECTED_BELOW_ENROLLMENT_GROUP_THRESHOLD.getCode().equals(status) ||
				EnrollmentStatus.CODE_REJECTED_INITIAL_APPLICATION_BY_VAMC.getCode().equals(status)){
			this.incrementRejectedEnrollment();
		}
		else if (EnrollmentStatus.CODE_CANCELLED_DECLINED.getCode().equals(status)){
			incrementCancelledDeclined();
		}			
	}

	public int getNumberWithCancelledDeclinedStatus() {
		return numberWithCancelledDeclinedStatus;
	}

	public int getNumberWithRejectedEnrollmentStatus() {
		return numberWithRejectedEnrollmentStatus;
	}

	private void incrementCancelledDeclined() {
		this.numberWithCancelledDeclinedStatus++;
	}

	private void incrementRejectedEnrollment() {
		this.numberWithRejectedEnrollmentStatus++;
	}
}
