package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.model.EntityKeyFactory;

import org.apache.commons.lang.Validate;

/**
 * Process for ESR Activation Phase I to add PSIM ESR correlation 
 * for the VPIDs provided in the input file.   A PSIM obtain call will
 * result in the correlation being added.
 * 
 * @author DNS   CHENJ2
 *
 */
public class AddPSIMCorrelationProcess extends
		AbstractDataFileSingleRowIncrementProcess {

	protected PSDelegateService psDelegateService;
	protected PersonService personService;
	
	protected boolean processDataRecord(
			DataFileProcessExecutionContext context, Object bean) {
		
		PSIMCorrelationFileData dataRecord = (PSIMCorrelationFileData) bean;

		boolean success = false;
		
		try {
			VPIDEntityKey vpidEntityKey = CommonEntityKeyFactory
            	.createVPIDEntityKey(dataRecord.getVpid());
			psDelegateService.getIdentityTraits(vpidEntityKey);
			success = true;
			
		} catch (Exception e) {
			if (logger.isErrorEnabled())
	           logger.error("Error adding PSIM Correlation for VPID " + dataRecord.getVpid(), e);
	            
			throw new RuntimeException(
	            "Error adding PSIM Correlation for VPID " + dataRecord.getVpid(), e); 

		}
		return success;		
	}
	

	public void afterPropertiesSet() {
		super.afterPropertiesSet();
		Validate.notNull(psDelegateService, "psDelegateService is required");
	}

	public PSDelegateService getPsDelegateService() {
		return psDelegateService;
	}

	public void setPsDelegateService(PSDelegateService psDelegateService) {
		this.psDelegateService = psDelegateService;
	}

}
