/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.FinancialsService;
import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;

import java.util.List;

import org.apache.commons.lang.Validate;

/**
 * Batch Process to trigger E&E and Z10's when the future dated test become effective.
 * 
 * @author DNS   MANSOG
 */
public class ActivateFutureMeansTestProcess extends AbstractDataQueryProcess {
	private FinancialsService	financialsService	= null;

	/**
	 * @see gov.va.med.fw.batchprocess.AbstractDataProcess#processData(gov.va.med.fw.batchprocess.DataProcessExecutionContext,
	 *      java.util.List)
	 */
	protected void processData(DataProcessExecutionContext context, List acquiredData) {
		if(logger.isInfoEnabled())
			logger.info("ActivateFutureMeansTestProcess: Query result Size="+(acquiredData == null ? 0 : acquiredData.size()));
		
		if (acquiredData == null)
			return;
		for (int i = 0; i < acquiredData.size(); i++) {
            PersonEntityKey personKey = null;
            Integer incomeYear = null;
            
            if(logger.isDebugEnabled())
                logger.debug("Processing record # " + (i+1) + ":: person id = " + personKey+" incomeYear = "+incomeYear);
			try {
                Object[] args = (Object[])acquiredData.get(i);
                personKey = CommonEntityKeyFactory.createPersonIdEntityKey(args[0].toString());
                incomeYear = (Integer) args[1];
                
                if(logger.isDebugEnabled())
                    logger.debug("Processing record # " + (i+1) + ":: person id = " + personKey+" incomeYear = "+incomeYear);
                
				financialsService.processFutureDatedTestFlag(personKey, incomeYear);
				context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
			} catch (Exception ex) {
				context.getProcessStatistics().incrementNumberOfErrorRecords();
				String errMsg = "Error while executing ActivateFutureMeansTestProcess batch process for person id = " + personKey+" incomeYear = "+incomeYear;
				context.getExceptionData().add(errMsg+ " Reason: "+ ex.getMessage());
				if(logger.isWarnEnabled())
					logger.warn(errMsg + " Reason: ", ex);
			}
		}
		if(logger.isDebugEnabled()) {
			logger.debug("ActivateFutureMeansTestProcess: Processing complete.");
			logger.debug("ActivateFutureMeansTestProcess: Successful records count = "+context.getProcessStatistics().getNumberOfSuccessfulRecords());
			logger.debug("ActivateFutureMeansTestProcess: Failure records count ="+context.getProcessStatistics().getNumberOfErrorRecords());
		}
	}
	
    /**
     * @return Returns the financialsService.
     */
    public FinancialsService getFinancialsService() {
        return financialsService;
    }
    
    /**
     * @param financialsService The financialsService to set.
     */
    public void setFinancialsService(FinancialsService financialsService) {
        this.financialsService = financialsService;
    }


    public void afterPropertiesSet() {
		super.afterPropertiesSet();
		Validate.notNull(financialsService, "A FinancialsService is needed");
	}
}
