package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.service.StandardReportService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.fw.batchprocess.AbstractDataProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;

import java.util.List;

/**
 * Contains logic to process completed reports.
 *
 * @author Venky Kulllampalle
 * @version 1.0
 *
 * Copyright  2006 VHA. All rights reserved
 */
public abstract class AbstractReportProcess extends AbstractDataProcess
{
    private StandardReportService reportService;
   
    private SystemParameterService systemParameterService;

    private String updateQueryString; 

    public SystemParameterService getSystemParameterService() {
        return systemParameterService;
    }


    public void setSystemParameterService(
            SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }


    /**
     * @return Returns the updateQueryString.
     */
    public String getUpdateQueryString()
    {
        return updateQueryString;
    }

   
    /**
     * @param updateQueryString
     * The updateQueryString to set.
     */
    public void setUpdateQueryString(String updateQueryString)
    {
        this.updateQueryString = updateQueryString;
    }  

    public StandardReportService getReportService() {
        return reportService;
    }


    public void setReportService(StandardReportService reportService) {
        this.reportService = reportService;
    }
    
    /**
     * Empty implementation.
     * @param context
     */    
    protected List acquireData(DataProcessExecutionContext context)
    throws Exception {
        return null;
    }
    
    /**
     * @param context.
     */
    protected  void executeProcess(DataProcessExecutionContext context)
    throws Exception {          
        processData(context,acquireData(context));  
        handleDataProcessCompleted(context);        
    }    
}