package gov.va.med.esr.common.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataQueryIncrementalProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;

/**
 * 
 * @author Rajiv Patnaik
 * Created on Apr 29, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public abstract class AbstractOPPExtractBaseProcess extends AbstractDataQueryIncrementalProcess
{

    private OPPExtractOutputFileProducer outputFileProducer;
    
    /**
     * @return Returns the outputFileProducer.
     */
    public OPPExtractOutputFileProducer getOutputFileProducer()
    {
        return outputFileProducer;
    }
    /**
     * @param outputFileProducer The outputFileProducer to set.
     */
    public void setOutputFileProducer(
            OPPExtractOutputFileProducer outputFileProducer)
    {
        this.outputFileProducer = outputFileProducer;
    }


    /* (non-Javadoc)
     * @see gov.va.med.fw.batchprocess.AbstractDataProcess#createProcessStatistics()
     */
    protected ProcessStatistics createProcessStatistics()
    {
        return new OPPExtractProcessStatistics();
    }
    
    protected DataProcessExecutionContext createDataProcessExecutionContext(boolean isConcurrrentProcessing)
    {
        OPPExtractExecutionContext context = new OPPExtractExecutionContext();
		context.setProcessStatistics(createProcessStatistics());
		return context;

    }
    
}
