package gov.va.med.esr.common.batchprocess;


import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.util.StringUtils;

/*
 * parses incoming files from CMS with invalid Element errors for ACA 1095B mail requests
 *
 */

public class ACAMailingResponseErrorFileData extends
           AbstractRawFileDataContainer  {
	/**
	 *
	 */
	private static final long serialVersionUID = -1564583385245001470L;
	private String formNum;
	private String vpid;
	private String element;


	protected void buildToString(ToStringBuilder builder) {
		builder.append("formNum", formNum).append("vpid", vpid).
			append("rejectCode", element);
	}

    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow,
            ClassMapping classMapping) throws Exception
    {
    	int i = 0;
    	this.setFormNumText(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setVPID(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setElement(StringUtils.stripToNull(parsedRow.getString(i++)));
    }

	protected List validateData(){
		ArrayList errors = new ArrayList();
		if ( formNum == null || formNum.length() <= 0 ) {
			errors.add("Missing FormNumber");
		}
		if ( vpid == null || vpid.length() <= 0 ) {
			errors.add("Missing VPID");
		}
		if ( element == null || element.length() <= 0) {
			errors.add("Missing Element");
		}
		return errors;
	}
    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception
    {
        // no op as this class is used only for parsing data from a input file
        return null;
    }

	public String getFormNumText() {
		return formNum;
	}

	public void setFormNumText(String formNum) {
		this.formNum = formNum;
	}

	public String getVPID() {
		return vpid;
	}

	public void setVPID(String Vpid) {
		this.vpid = Vpid;
	}

	public String getElement() {
		return element;
	}

	public void setElement(String element) {
		this.element = element;
	}

}
