package gov.va.med.esr.common.batchprocess;


import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.infomata.data.DataRow;

import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.util.StringUtils;

/*
 * parses incoming files from CMS with successful mail requests in address file for ACA 1095B mail requests
 *
 */

public class ACAMailingResponseAddressFileData extends
           AbstractRawFileDataContainer  {
	/**
	 *
	 */
	private static final long serialVersionUID = -1564583385245001470L;
	private String formNum;
	private String vpid;
	private String name;
	private String addressline1;
	private String addressline2;
	private String city;
	private String state;
	private String zip;
	private String emailaddress;
	private String datemailed;


	protected void buildToString(ToStringBuilder builder) {
		builder.append("formNum", formNum).append("vpid", vpid).
			append("name", name)
			.append("addressline1", addressline1)
			.append("addressline2", addressline2)
			.append("city", city)
			.append("state", state)
			.append("zip", zip)
			.append("emailaddress", emailaddress)
			.append("datemailed", datemailed);
	}

    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#setRawFileData(java.lang.String, com.infomata.data.DataRow, gov.va.med.fw.io.ClassMapping)
     */
    public void setRawFileData(String rawFileData, DataRow parsedRow,
            ClassMapping classMapping) throws Exception
    {
    	int i = 0;
    	this.setFormNumText(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setVPID(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setName(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setAddressline1(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setAddressline2(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setCity(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setState(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setZip(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setEmailaddress(StringUtils.stripToNull(parsedRow.getString(i++)));
    	this.setDatemailed(StringUtils.stripToNull(parsedRow.getString(i++)));
    }

	protected List validateData(){
		ArrayList errors = new ArrayList();
		if ( formNum == null || formNum.length() <= 0 ) {
			errors.add("Missing FormNumber");
		}
		if ( vpid == null || vpid.length() <= 0 ) {
			errors.add("Missing VPID");
		}
		return errors;
	}
    /* (non-Javadoc)
     * @see gov.va.med.fw.io.RawFileDataContainer#getRawFileData()
     */
    public OrderedMap getRawFileData() throws Exception
    {
        // no op as this class is used only for parsing data from a input file
        return null;
    }

	public String getFormNumText() {
		return formNum;
	}

	public void setFormNumText(String formNum) {
		this.formNum = formNum;
	}

	public String getVPID() {
		return vpid;
	}

	public void setVPID(String Vpid) {
		this.vpid = Vpid;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAddressline1() {
		return addressline1;
	}

	public void setAddressline1(String addressline1) {
		this.addressline1 = addressline1;
	}

	public String getAddressline2() {
		return addressline2;
	}

	public void setAddressline2(String addressline2) {
		this.addressline2 = addressline2;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}

	public String getDatemailed() {
		return datemailed;
	}

	public void setDatemailed(String datemailed) {
		this.datemailed = datemailed;
	}

	public String getEmailaddress() {
		return emailaddress;
	}

	public void setEmailaddress(String emailaddress) {
		this.emailaddress = emailaddress;
	}

}
