
package gov.va.med.esr.common.batchprocess;

import java.util.Date;

import gov.va.med.fw.model.AbstractKeyedEntity;


/**
 * @author DNS   faulkj
 *
 * collects all the statistics required to send bulletin for the print order
 *
 */
public class ACAExportStatistics extends AbstractKeyedEntity {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5284593887794163278L;


	public static String LINE_BREAK = "\n";

	String filename;

	private Date startTime;

	private Date endTime;

	private int numberSent = 0;

	private int numberRejected = 0;

	private int numberErrAddress = 0;

	private int numberErrSuppress = 0;

	private int numberErrDuplicate = 0;

	private int numberErrIdentity = 0;

	private int numberErrOther = 0;

	private int numberForm800A = 0;

	private int numberForm800D = 0;



    public ACAExportStatistics() {
		super();
	}



	public String getFilename() {
		return filename;
	}



	public void setFilename(String filename) {
		this.filename = filename;
	}



	public Date getStartTime() {
		return startTime;
	}



	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}



	public Date getEndTime() {
		return endTime;
	}



	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public void incrementNumberSent() {
		numberSent = numberSent + 1;
	}

	public int getNumberSent() {
		return numberSent;
	}



	public void setNumberSent(int numberSent) {
		this.numberSent = numberSent;
	}



	public int getNumberRejected() {
		numberRejected =  numberErrAddress + numberErrSuppress + numberErrDuplicate + numberErrIdentity + numberErrOther;

		return numberRejected;
	}




	public void setNumberRejected(int numberRejected) {
		this.numberRejected = numberRejected;
	}


	public void incrementNumberErrAddress() {
		numberErrAddress = numberErrAddress + 1;
	}

	public int getNumberErrAddress() {
		return numberErrAddress;
	}



	public void setNumberErrAddress(int numberErrAddress) {
		this.numberErrAddress = numberErrAddress;
	}

	public void incrementNumberErrSuppress() {
		numberErrSuppress = numberErrSuppress + 1;
	}

	public int getNumberErrSuppress() {
		return numberErrSuppress;
	}



	public void setNumberErrSuppress(int numberErrSuppress) {
		this.numberErrSuppress = numberErrSuppress;
	}

	public void incrementNumberErrDuplicate() {
		numberErrDuplicate = numberErrDuplicate + 1;
	}

	public int getNumberErrDuplicate() {
		return numberErrDuplicate;
	}



	public void setNumberErrDuplicate(int numberErrDuplicate) {
		this.numberErrDuplicate = numberErrDuplicate;
	}

	public void incrementNumberErrIdentity() {
		numberErrIdentity = numberErrIdentity + 1;
	}

	public int getNumberErrIdentity() {
		return numberErrIdentity;
	}



	public void setNumberErrIdentity(int numberErrIdentity) {
		this.numberErrIdentity = numberErrIdentity;
	}

	public void incrementNumberErrOther() {
		numberErrOther = numberErrOther + 1;
	}

	public int getNumberErrOther() {
		return numberErrOther;
	}



	public void setNumberErrOther(int numberErrOther) {
		this.numberErrOther = numberErrOther;
	}


	public void incrementNumberForm800A() {
		numberForm800A = numberForm800A + 1;
	}

	public int getNumberForm800A() {
		return numberForm800A;
	}



	public void setNumberForm800A(int numberForm800A) {
		this.numberForm800A = numberForm800A;
	}

	public void incrementNumberForm800D() {
		numberForm800D = numberForm800D + 1;
	}

	public int getNumberForm800D() {
		return numberForm800D;
	}



	public void setNumberForm800D(int numberForm800D) {
		this.numberForm800D = numberForm800D;
	}


}
