<script language="javascript" src="../scripts/ESR-Script.js"></script>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/tags/fw" prefix="fw"%>
<%@ taglib uri="/tags/struts-bean" prefix="bean"%>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el"%>
<%@ taglib uri="/tags/struts-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el"%>

<c:set var="requiredText">
	<bean-el:message key="label.required" />
</c:set>

<c:set var="percentageLabel">
	<bean-el:message key="label.relaxationPercentage.percentage" />
</c:set>

<c:set var="editActive" value="false" />
<auth:authorize ifAnyGranted="${editCapability}">
	<c:set var="editActive" value="true" />
</auth:authorize>

<script type="text/javascript">
	var allRPs = new Object()
	<c:forEach items="${relaxationPercentageUpdateForm.allRelaxationPercentages}" var="rp">
	allRPs['<c:out value="${rp.incomeYear}" />'] = <c:out value="${rp.value}" />
	</c:forEach>

	function updateYear(theInput) {
		var incomeYear = theInput.options[theInput.selectedIndex].value
		document.getElementById('rpValueInput').value = allRPs[incomeYear]
		document.getElementById('valueLabelSpan').innerHTML = '<bean-el:message
			key="label.relaxationPercentage.percentage" /> for ' + incomeYear + ':'
		<c:if test="${editActive}">
			var pastYearSelected = (incomeYear < <c:out value="${relaxationPercentageUpdateForm.currentIncomeYear}" />)
			document.getElementById('updateButton').disabled = pastYearSelected
			document.getElementById('rpValueInput').disabled = pastYearSelected
		</c:if>
	}
</script>

<table width="100%" border="1" cellpadding="0" cellspacing="0"
	class="moduleShell" role="presentation">
	<html:form action="/relaxationPercentage" method="post">
	  <%@ include file="/admin/csrfgentoken.jsp" %>
		<tr>
			<td>
			<table width="100%" border="0" cellpadding="0" cellspacing="0"
				class="moduleShellTable" role="presentation">
				<tr>
					<td>
					<table width="100%" border="0" cellpadding="0" cellspacing="0"
						class="moduleShellTableHead" role="presentation">
						<tr>
							<td class="moduleBlueBox"><img alt=""
								src="../images/spacer.gif" width="28" height="23" /></td>
							<td nowrap class="moduleHeadline"><bean-el:message
								key="label.relaxationPercentage" /></td>
							<td width="100%"><img alt="" src="../images/spacer.gif" /></td>
							<c:if test="${editActive and not relaxationPercentageUpdateForm.nextIncomeYearDefined}">
								<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
						          <fw:link action="/relaxationPercentageAdd?methodName=displayAdd">
						            <bean-el:message key="label.relaxationPercentage.newRelaxationPercentage"/>
						          </fw:link>
						        </td>
						    </c:if>
							<td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
					          <fw:link action="/relaxationPercentageHistory?methodName=DISPLAY&amp;history=viewHistoricalRelaxationPercentages">
					            <bean-el:message key="label.relaxationPercentage.viewHistoricalRelaxationPercentages"/>
					          </fw:link>
					        </td>
						</tr>
					</table>
					</td>
				</tr>

				<tr>
					<td>
					<table width="100%" border="0" cellspacing="0" cellpadding="0"
						class="moduleShellTableBody" role="presentation">
                        <tr>
                            <td colspan="2">
                              <%@ include file="/tiles/common/instructionalText.jsp" %>
                            </td>
                        </tr>
						<tr>
							<td style="padding: 10 20 10 10">
							<table width="100%" border="0" cellspacing="0" cellpadding="0" role="presentation">
								<tr>
									<c:set var="incomeYearLabel">
										<bean-el:message key="label.relaxationPercentage.incomeYear" />
									</c:set>
									<td width="45%" class="moduleLabel"><fw:label
										property="incomeYear" forId="idIncomeYear">
										<bean-el:message key="label.relaxationPercentage.incomeYear" />:</fw:label></td>
									<td width="55%" class="moduleValue"><html-el:select
										onchange="updateYear(this)"
										title="${requiredText}, ${incomeYearLabel}"
										property="incomeYear" styleId="idIncomeYear" tabindex="1">
										<bean:define name="relaxationPercentageUpdateForm"
											property="allRelaxationPercentages" id="rpList" />
										<html-el:options collection="rpList" property="incomeYear"
											labelProperty="incomeYear" />
									</html-el:select></td>
								</tr>
								<tr>
									<td width="45%" class="moduleLabel"><fw:label
										required="true" property="value" forId="rpValueInput">
										<span id="valueLabelSpan"><bean-el:message key="label.relaxationPercentage.percentage" /> for
										<c:out value="${relaxationPercentageUpdateForm.incomeYear}" />:</span></fw:label></td>
									<td width="55%" class="moduleValue"><html-el:text disabled="${not editActive}"
										styleId="rpValueInput"
										title="${requiredText}, ${percentageLabel}" property="value"
										size="25" maxlength="30" tabindex="2" /></td>
								</tr>
								<c:if test="${editActive}">
								<tr>
									<c:set var="retroactiveLabel">
										<bean-el:message
											key="label.relaxationPercentage.retroactiveProcessing" />
									</c:set>
									<td width="45%" class="moduleLabel"><html-el:checkbox
										title="${requiredText}, ${retroactiveLabel}"
										property="retroactiveProcess" tabindex="3" styleId="retroactiveProcessingId"/></td>
									<td width="55%" class="moduleValue"><fw:label
										property="value" forId="retroactiveProcessingId">
										<bean-el:message
											key="label.relaxationPercentage.retroactiveProcessing" />
									</fw:label></td>
								</tr>
								</c:if>
							</table>
							</td>
						</tr>
	
						<%-- Button Row --%>
						<c:if test="${editActive}">
						<tr>
							<td height="50">
							<table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
								<tr>
									<td width="45%"><img alt="" src="../images/spacer.gif" /></td>
									<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
									<td><html-el:submit property="methodName" styleId="updateButton"
										style="width:50; vertical-align: top;" tabindex="5"
										styleClass="buttonText">
										<bean-el:message key="button.update" />
									</html-el:submit></td>
									<td><img alt="" src="../images/buttonEndRight.gif" /></td>
									<td width="1%"><img alt="" src="../images/spacer.gif" /></td>
									<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
									<td><html-el:submit property="methodName"
										style="width:50; vertical-align: top;" tabindex="6"
										styleClass="buttonText">
										<bean-el:message key="button.reset" />
									</html-el:submit></td>
									<td><img alt="" src="../images/buttonEndRight.gif" /></td>
									<td width="1%"><img alt="" src="../images/spacer.gif" /></td>
									<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
									<td><html-el:submit property="methodName"
										style="width:50; vertical-align: top;" tabindex="7"
										styleClass="buttonText">
										<bean-el:message key="button.cancel" />
									</html-el:submit></td>
									<td><img alt="" src="../images/buttonEndRight.gif" /></td>
									<td width="45%"><img alt="" src="../images/spacer.gif" /></td>
								</tr>
							</table>
							</td>
						</tr>
						</c:if>
					</table>
					</td>
				</tr>
			</table>
			</td>
		</tr>
	</html:form>
</table>
