<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ page import="gov.va.med.esr.common.model.lookup.EmploymentStatus" %>

<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/></c:set>

<c:set var="status_retired" scope="page" ><%=EmploymentStatus.CODE_RETIRED.getName()%></c:set>
<c:set var="status_unemployed" scope="page"><%=EmploymentStatus.CODE_NOT_EMPLOYED.getName()%></c:set>
<c:set var="status_unknown" scope="page"><%=EmploymentStatus.CODE_UNKNOWN.getName()%></c:set>

<c:set var="countryEditable" scope="page" value="true"/>
<c:set var="zipCodeLookup" scope="page" value="true"/>
<c:set var="nullCountryAllowed" scope="page" value="true"/>


<%-- add a person flag --%>
<c:set var="isAddAPerson" value="false"></c:set>
<c:if test="${financialsDependentForm.addAPerson == 'true'}">
    <c:set var="isAddAPerson" value="true"></c:set>
</c:if>
<%-- c:set var="isAddAPerson" scope="page" value="true" /--%>

<script src="../scripts/ESR-Script.js" type="text/javascript"></script>
<script>
  function onLoadInit()
  {
    if (financialsDependentForm.addAPerson.value == 'true')
    {
  		updateCountryFields();
    }    
    
  }
  
  
  
  function onLoadInitSpouse()
  {
  	if (financialsDependentForm.addAPerson.value == 'true')
  	 	updateCountryFields();
     enableDateOfRetirement(financialsDependentForm, '<c:out value="${status_retired}"/>'); 
     
     processSpouseLivedWithVeteran();
  }
  
  
  function processContributedToSpouseInd(flag, elem)
  {
	  if(flag == true)
	  {
		  elem.checked = false;
		  var spousalContribution = document.getElementsByName('spouseInfo.contributedToSpouseInd');
		  for (var i =0; i<spousalContribution.length; i++){
			  spousalContribution[i].value = null;  
		  }		  
	  }	  
	  else
	  { 
		  if(elem.id =="idContributedToSpouseInd_y")
		  {
			  elem.value="y";
		  } 	  
		  else if(elem.id =="idContributedToSpouseInd_n")
          {
              elem.value="n";
          } 
	  }
  }
  
  
  function processSpouseLivedWithVeteran()
  {
    var indicator_n = document.getElementById('idLivedWithVeteran_n');
    var block = document.getElementById('spouseLwvBlock');
    var imageElement = document.getElementById('lwvArrowImage');

    if (indicator_n.value != null && indicator_n.checked)
    {
      expandSection(block, imageElement, null);
    }
    else
    {
      collapseSection(block, imageElement, null);
    }
  }

</script>

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
<tr>
    <td colspan="2">
      <%@ include file="/tiles/common/instructionalText.jsp" %>
    </td>
</tr>
<tr>
<td width="45%" class="moduleLabel"><fw:label property="spouseInfo.prefix" forId="idSpousePrefix">Prefix:</fw:label></th>
<td width="55%" class="moduleValue"><html-el:text title="Prefix" styleClass="moduleEdit initfocus" property="spouseInfo.prefix" styleId="idSpousePrefix" size="25" maxlength="25"/></td>
</tr>
<tr>
<td class="moduleLabel"><fw:label required="true" property="spouseInfo.firstName" forId="idSpouseFirstName">First Name:</fw:label></th>
<td  class="moduleValue"><html-el:text title="${requiredText}, First Name" styleClass="moduleEdit" property="spouseInfo.firstName" styleId="idSpouseFirstName" size="40" maxlength="40"/></td>
</tr>
<tr>
<td class="moduleLabel"><fw:label property="spouseInfo.middleName" forId="idSpouseMiddleName">Middle Name:</fw:label></th>
<td  class="moduleValue"><html-el:text title="Middle Name" styleClass="moduleEdit" property="spouseInfo.middleName" styleId="idSpouseMiddleName" size="40" maxlength="40"/></td>
</tr>
<tr>
<td class="moduleLabel"><fw:label required="true" property="spouseInfo.lastName" forId="idSpouseLastName">Last Name:</fw:label></th>
<td  class="moduleValue"><html-el:text title="${requiredText}, Last Name" styleClass="moduleEdit" property="spouseInfo.lastName" styleId="idSpouseLastName" size="40" maxlength="40"/></td>
</tr>
<tr>
<td class="moduleLabel"><fw:label property="spouseInfo.maidenName" forId="idSpouseMaidenName">Maiden Name:</fw:label></th>
<td  class="moduleValue"><html-el:text title="Maiden Name" styleClass="moduleEdit" property="spouseInfo.maidenName" styleId="idSpouseMaidenName" size="40" maxlength="40"/></td>
</tr>
<tr>
<td class="moduleLabel"><fw:label property="spouseInfo.suffix" forId="idSpouseSuffix">Suffix:</fw:label></th>
<td  class="moduleValue"><html-el:text title="Suffix" styleClass="moduleEdit" property="spouseInfo.suffix" styleId="idSpouseSuffix" size="25" maxlength="25"/></td>
</tr>
<tr>
<td class="moduleLabel"><fw:label property="spouseInfo.ssn" forId="idSpouseSSN">SSN:</fw:label></th>
<td  class="moduleValue"><html-el:text title="SSN" styleClass="moduleEdit" property="spouseInfo.ssn" styleId="idSpouseSSN" size="25" maxlength="25" onkeypress="return validateSSN(event)" onkeyup="formatSSN(event)" onblur="formatSSN(event)"/></td>
</tr>
<tr>
<td class="moduleLabel"><fw:label property="spouseInfo.pseudoSsn" forId="idSpousePseudoSsn">Pseudo SSN:</fw:label></th>
<td  class="moduleValue">
	<html-el:hidden property="spouseInfo.pseudoSsn" />
	<esrcore:displayValue name="financialsDependentForm" property="spouseInfo.pseudoSsn"/>
</td>
</tr>
  <tr>
    <td width="45%" class="moduleLabel"><fw:label property="spouseInfo.pseudoSsnReason" forId="idSpousePseudoSsnReason">Pseudo SSN Reason:</fw:label></th>
    <td width="55%" class="moduleValue">
		<html-el:select title="Pseudo SSN Reason" styleClass="darkValue" property="spouseInfo.pseudoSsnReason" styleId="idSpousePseudoSsnReason">
		<html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
		<esrcore:options collection="gov.va.med.esr.common.model.lookup.PseudoSSNReason" property="code" labelProperty="description"/>
		</html-el:select>
	</td>
  </tr>
</table>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
<tr>
<td width="45%" class="moduleLabel"><bean-el:message key="label.required.prefix" />&nbsp;Gender:</th>
<td width="55%"  class="moduleValue">
       <c:set var="maleLabel"><bean-el:message key="label.male"/></c:set>
       <c:set var="femaleLabel"><bean-el:message key="label.female"/></c:set>
	<html-el:radio title="${requiredText}, Gender (${maleLabel})" property="spouseInfo.genderCode" styleId="idSpouseGenderCode_M" value="M"/>
	<fw:label property="spouseInfo.genderCode" forId="idSpouseGenderCode_M"><bean-el:message key="label.male"/></fw:label>
	<html-el:radio title="${requiredText}, Gender (${femaleLabel})"  property="spouseInfo.genderCode" styleId="idSpouseGenderCode_F" value="F"/>
	<fw:label property="spouseInfo.genderCode" forId="idSpouseGenderCode_F"><bean-el:message key="label.female"/></fw:label>
</td>
</tr>
<tr>
  <td class="moduleLabel"><fw:label required="true" property="spouseInfo.dateOfBirth" forId="idSpouseDateOfBirth">Date of Birth:</fw:label></th>
  <td  class="moduleValue"><html-el:text title="${requiredText}, Date of Birth ${mmddyyyyText}" styleClass="moduleEdit" styleId="idSpouseDateOfBirth" property="spouseInfo.dateOfBirth" size="25" maxlength="25"/>&nbsp;<bean-el:message key="label.mmddyyyy" /></td>
</tr>
<tr>
<td class="moduleLabel"><fw:label required="true" property="spouseInfo.marriageDate" forId="idSpouseMarriageDate">Date of Marriage:</fw:label></th>
<td  class="moduleValue"><html-el:text title="${requiredText}, Date of Marriage ${mmddyyyyText}" styleClass="moduleEdit" styleId="idSpouseMarriageDate" property="spouseInfo.marriageDate" size="25" maxlength="25"/>&nbsp;<bean-el:message key="label.mmddyyyy" /></td>
</tr>
<!-- Defect288710-AAP-Spouse Marriage Date needs data validation and consistency checks-->
	<td class="moduleValue"><html-el:hidden property="spouseInfo.veteranDob" value="${veteranHeaderBean.dob}"/>
<tr>
  <td class="moduleLabel"><fw:label property="spouseInfo.inactiveDate" forId="idSpouseInactiveDate">Inactive Date:</fw:label></th>
  <td class="moduleValue"><html-el:text title="Inactive Date ${mmddyyyyText}" styleClass="moduleEdit" styleId="idSpouseInactiveDate" property="spouseInfo.inactiveDate" size="25" maxlength="25"/>&nbsp;<bean-el:message key="label.mmddyyyy" /></td>
</tr>
<tr>

<tr valign="top">
<td class="moduleLabel"><fw:label property="spouseInfo.address" forId="idSpouseAddress">Address:</fw:label></td>
<td class="moduleValue">
	<html-el:hidden property="spouseInfo.address" />
	<esrcore:displayValue name="financialsDependentForm" property="spouseInfo.address"/>
</td>
</tr>

<tr valign="top">
<td class="moduleLabel"><fw:label property="spouseInfo.addressChangeDate" forId="idSpouseAddressChangeDate">Last Changed:</fw:label></td>
<td class="moduleValue">
	<html-el:hidden property="spouseInfo.addressChangeDate" />
	<esrcore:displayValue name="financialsDependentForm" property="spouseInfo.addressChangeDate"/>
</td>
</tr>
<tr>
<td class="moduleLabel"><fw:label property="spouseInfo.phone" forId="idSpousePhone">Home Phone:</fw:label></td>
<td class="moduleValue">
	<html-el:hidden property="spouseInfo.phone" />
	<esrcore:displayValue name="financialsDependentForm" property="spouseInfo.phone"/>
</td>
</tr>

</table>

<c:if test="${pageName == 'financialsDependentAdd'}">
  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
    <tr>
      <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="lwvArrowImage" src="../images/redArrowRight.gif" />Lived with Veteran Last Calendar Year:</td>
      <td width="55%" class="moduleValue">
        <c:forEach var="item" items="${yesNoList}">
          <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
          <html-el:radio title="Lived with Veteran Last Calendar Year (${itemLabel})" styleId="idLivedWithVeteran_${item.value}" property="spouseInfo.livedWithVeteran" onclick="processSpouseLivedWithVeteran();" value="${item.value}"/>
          <fw:label property="spouseInfo.livedWithVeteran" forId="idLivedWithVeteran_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
        </c:forEach>
      </td>
    </tr>
  </table>
  
   <%-- livedWithVeteran Expand/Collapse Section --%>
  <div id="spouseLwvBlock" class="expandCollapseBody">
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
      <tr>
      <td width="45%" class="moduleLabel" nowrap>Contributed to Spousal Support:</td>
      <td width="55%" class="moduleValue">
        <c:forEach var="item" items="${yesNoList}">
          <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
          <html-el:radio title="Contributed to Spousal Support (${itemLabel})" styleId="idContributedToSpouseInd_${item.value}" property="spouseInfo.contributedToSpouseInd" disabled="false" value="${item.value}" onmousedown="this.__chk = this.checked;" onclick="processContributedToSpouseInd(this.__chk, this);"/>
          <fw:label property="spouseInfo.contributedToSpouseInd" forId="idContributedToSpouseInd_${item.value}"><bean-el:message key="${item.label}" /></fw:label>      
        </c:forEach>
        <html-el:hidden property="spouseInfo.contributedToSpouseInd"/>          
      </td>
    </tr>
    </table>
  </div>
 
</c:if>

<c:if test="${pageName == 'financialsDependentEdit'}">
	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
		
    <tr>
      <td width="45%" class="moduleLabel" nowrap><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="lwvArrowImage" src="../images/redArrowRight.gif" />Lived with Veteran Last Calendar Year:</th>
      <td width="55%" class="moduleValue">
        <c:forEach var="item" items="${yesNoList}">
          <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
          <html-el:radio title="Lived with Veteran Last Calendar Year (${itemLabel})" styleId="idLivedWithVeteran_${item.value}" property="spouseInfo.livedWithVeteran" disabled="true" value="${item.value}" />
          <fw:label property="spouseInfo.livedWithVeteran" forId="idLivedWithVeteran_${item.value}"><bean-el:message key="${item.label}" /></fw:label>		
        </c:forEach>
        <html-el:hidden property="spouseInfo.livedWithVeteran"/>		  
      </td>
    </tr>
    </table>
    <%-- livedWithVeteran Expand/Collapse Section --%>
  <div id="spouseLwvBlock" class="expandCollapseBody">
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
    <tr>
      <td width="45%" class="moduleLabel" nowrap>Contributed to Spousal Support:</td>
      <td width="55%" class="moduleValue">
        <c:forEach var="item" items="${yesNoList}">
          <c:set var="itemLabel"><bean-el:message key="${item.label}"/></c:set>
          <html-el:radio title="Contributed to Spousal Support (${itemLabel})" styleId="idContributedToSpouseInd_${item.value}" property="spouseInfo.contributedToSpouseInd" disabled="false" value="${item.value}" onmousedown="this.__chk = this.checked;" onclick="processContributedToSpouseInd(this.__chk, this);"/>
          <fw:label property="spouseInfo.contributedToSpouseInd" forId="idContributedToSpouseInd_${item.value}"><bean-el:message key="${item.label}" /></fw:label>      
        </c:forEach>
        <html-el:hidden property="spouseInfo.contributedToSpouseInd"/>          
      </td>
    </tr>
     </table>
  </div>    
   
   <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">				
	<tr>
	<td width="45%" class="moduleLabel"><fw:label property="spouseInfo.ssnSourceOfChange" forId="spouseSsnSourceOfChangeId">SSN Source of Change:</fw:label></th>
	<td width="55%" class="moduleValue">
		<html-el:select styleClass="darkValue" property="spouseInfo.ssnSourceOfChange" styleId="spouseSsnSourceOfChangeId">
		<html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
		<esrcore:options collection="gov.va.med.esr.common.model.lookup.SSNChangeSource" property="code" labelProperty="description"/>
		</html-el:select>
	</td>
	</tr>
	<tr>
	<td class="moduleLabel"><fw:label property="spouseInfo.ssaVerificationStatus" forId="spouseSsaVerificationStatusId">SSA Verification Status:</fw:label></th>
	<td class="moduleValue">
		<html-el:select styleClass="darkValue" property="spouseInfo.ssaVerificationStatus" styleId="spouseSsaVerificationStatusId">
		<html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
		<esrcore:options collection="gov.va.med.esr.common.model.lookup.SSAVerificationStatus" property="code" labelProperty="description"/>
		</html-el:select>
	</td>
	</tr>
	<tr>
	<td class="moduleLabel">SSA Verification Date:</td>
	<td class="moduleValue">
		<html-el:hidden property="spouseInfo.ssaVerificationDate" />
		<esrcore:displayValue name="financialsDependentForm" property="spouseInfo.ssaVerificationDate"/>
	</td>
	</tr>
	<tr>
	<td class="moduleLabel">SSA Message:</td>
	<td class="moduleValue">
		<html-el:hidden property="spouseInfo.ssaMessage" />
		<esrcore:displayValue name="financialsDependentForm" property="spouseInfo.ssaMessage"/>
	</td>
	</tr>
</table>
</c:if>

<!--  Employment section  -->
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableBody" role = "presentation">
<tr>
  <td width="45%"  class="moduleLabel"><fw:label property="employmentStatus" forId="idEmploymentStatus">Employment Status:</fw:label></td>
  <td width="55%" class="moduleValue">
    <c:set var="employmentStatusText">Employment Status</c:set>
    <html-el:select title="${employmentStatusText}" styleClass="moduleEdit" styleId="idEmploymentStatus" property="spouseInfo.employmentStatus" onchange="updateEmploymentFields(financialsDependentForm, ${status_retired})">
      <html-el:option value=""><bean-el:message key="label.select"/></html-el:option>
      <esrcore:options collection="gov.va.med.esr.common.model.lookup.EmploymentStatus" property="code" labelProperty="description"/>
    </html-el:select>
    <html-el:hidden name="financialsDependentForm" styleId="idOnFileEmploymentStatus" property="spouseInfo.onFileEmploymentStatus"></html-el:hidden> 
    </td>
</tr>

<tr>
     <td width="45%" class="moduleLabel"></td>
     <td width="55%" class="moduleValue"></td>
</tr>

<tr>
  <td class="moduleLabel"><fw:label property="employerName" forId="idEmployerNameHidden"><bean-el:message key="label.dep.employerName"/>:</fw:label></td>
  <td id="employerNameEdit" class="moduleValue">
  <c:set var="employerNameText"><bean-el:message key="label.dep.employerName"/></c:set>    
	<html-el:text title="${employerNameText}" styleClass="moduleEdit" styleId="idEmployerNameHidden" property="spouseInfo.employerName" size="40" maxlength="40" readonly="${not isAddAPerson}" />
  </td>
</tr>

<tr>
  <td class="moduleLabel"><fw:label property="occupation" forId="idOccupationHidden"><bean-el:message key="label.dep.occupation"/>:</fw:label></td>
  <td id="occupationEdit" class="moduleValue">
  <c:set var="occupationText"><bean-el:message key="label.dep.occupation"/></c:set>    
	<html-el:text title="${occupationText}" styleClass="moduleEdit"  styleId="idOccupationHidden" property="spouseInfo.occupation" size="40" maxlength="40" readonly="${not isAddAPerson}" />
  </td>
</tr>

<c:choose>
<c:when test="${isAddAPerson}">	
<tr>
 <td colspan="2" style="padding-top: 10px"><%@ include file="/tiles/common/addressForm.jsp" %></td>
</tr>
</c:when>
<c:otherwise>
<tr  valign="top">
  <td class="moduleLabel"><fw:label property="employerAddress" forId="idEmployerAddressHidden">Employer Address:</fw:label></td>
  <td title="Employer Address" class="moduleValue">
    <esrcore:displayValue name="financialsDependentForm" property="spouseInfo.employerAddress"/>
   <html-el:hidden styleId="idEmployerAddressHidden" property="spouseInfo.employerAddress"></html-el:hidden>  
  </td>
</tr>
</c:otherwise>
</c:choose>
 
<tr>
  <td class="moduleLabel"><fw:label property="employerPhone" forId="idEmployerPhoneHidden"><bean-el:message key="label.dep.employerPhone"/>:</fw:label></td>
  <td id="employerPhoneEdit" class="moduleValue">
  <c:set var="employerPhoneText"><bean-el:message key="label.dep.employerPhone"/></c:set>    
	<html-el:text title="${employerPhoneText}" styleClass="moduleEdit" styleId="idEmployerPhoneHidden" property="spouseInfo.employerPhone" size="40" maxlength="15" readonly="${not isAddAPerson}" />
  </td>
</tr>

<tr>
  <td class="moduleLabel"><fw:label property="dateOfRetirement" forId="idDateOfRetirement"><bean-el:message key="label.dep.dateOfRetirement"/>:</fw:label></td>
  <td  class="moduleValue">
  	<c:set var="dateOfRetirementText"><bean-el:message key="label.dep.dateOfRetirement"/>&nbsp;<c:out value="${mmddyyyyText}"/></c:set>
  	<html-el:text title="${dateOfRetirementText}" styleId="idDateOfRetirement" styleClass="moduleEdit" property="spouseInfo.retirementDate" size="20" maxlength="21"/>&nbsp;<bean-el:message key="label.mmddyyyy"/>
    <html-el:hidden styleId="idDateOfRetirementHidden" property="spouseInfo.retirementDate"></html-el:hidden>	
  </td>
</tr>
		<html-el:hidden name="financialsDependentForm" property="addAPerson"/>
</table>

	
