<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/valuelist" prefix="vlh" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="currentEGTSettingKey" value="currentEGTSetting"/>
<c:set var="currentEGTSetting" value="${AppData[currentEGTSettingKey]}" />
<c:set var="processStatistic" value="${currentEGTSetting.processStatistic}" />

<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
<html-el:form action="/egtSettingOverview" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
      <%-- Enrollment Group Threshold Processing Section --%>
      <tr>
        <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
            <tr>
              <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
              <td nowrap style="padding-left: 7"><bean-el:message key="label.egt.egtThresholdProcessingHeader"/></td>
              <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <td>
<%@ include file="egtProcessingForm.jsp" %>
        </td>
      </tr>
    </table>
  </td>
</tr>
</table>

<br>

<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell">
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
     <auth:authorize ifAnyGranted="<%=Capability.VIEW_EGT_SETTINGS.getName()%>">
      <%-- Current Enrollment Group Threshold Setting Section --%>
      <tr>
        <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
            <tr>
              <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
              <td nowrap style="padding-left: 7"><bean-el:message key="label.egt.currentEGTSettingHeader"/></td>
              <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
              <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8"><fw:link action="/egtSettingHistory?methodName=DISPLAY&amp;history=viewHistoricalEGTSettings"><bean-el:message key="button.egt.viewHistoricalEGTSettings"/></fw:link></td>
            </tr>
          </table>
        </td>
      </tr>
      <tr>
        <td>
            <table summary="Current Enrollment Group Threshold Setting" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
            <thead>
              <tr>
                <th scope="col" style="text-align:left; padding-left: 5px" class="darkLabel"><u><bean-el:message key="label.egt.egtEffectiveDate"/></u></th>
                <th scope="col" style="text-align:left; padding-left: 5px" class="darkLabel"><u><bean-el:message key="label.egt.egtType"/></u></th>
                <th scope="col" style="text-align:left; padding-left: 5px" class="darkLabel"><u><bean-el:message key="label.egt.egtPriority"/></u></th>
                <th scope="col" style="text-align:left; padding-left: 5px" class="darkLabel"><u><bean-el:message key="label.egt.federalRegisterDate"/></u></th>
                <th scope="col" style="text-align:left; padding-left: 5px" class="darkLabel"><u><bean-el:message key="label.egt.processStatus"/></u></th>
                <th scope="col" style="text-align:left; padding-left: 5px" class="darkLabel"><u><bean-el:message key="label.egt.processStartDateTime"/></u></th>
                <th scope="col" style="text-align:left; padding-left: 5px" class="darkLabel"><u><bean-el:message key="label.egt.processEndDateTime"/></u></th>
              </tr>
               </thead>
               <tbody>
              <tr>
                <td scope="row" class="value" valign="top" nowrap>
                  <esrcore:displayDate name="currentEGTSetting" dateProperty="effectiveDate" displayTime="false" nullText=""/>
                </td>
                <td class="value" valign="top" nowrap>
                  <esrcore:displayValue name="currentEGTSetting" property="type" nullText=""/>
                </td>
                <td class="value" valign="top" nowrap>
                  <esrcore:displayValue name="currentEGTSetting" property="priorityGroup.code" nullText=""/><esrcore:displayLookupValue name="currentEGTSetting" property="prioritySubGroup.code" lookupType="gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup" lookupProperty="description"/>
                </td>
                <td class="value" valign="top" nowrap>
                  <esrcore:displayDate name="currentEGTSetting" dateProperty="federalRegisterDate" displayTime="false" nullText=""/>
                </td>
                <td class="value" valign="top" nowrap>
                  <esrcore:displayValue name="currentEGTSetting" property="processStatistic.egtProcessStatus" nullText=""/>
                </td>
                <td class="value" valign="top" nowrap>
                  <esrcore:displayDate name="currentEGTSetting" dateProperty="processStatistic.processStartDate" displayTime="true" nullText=""/>
                </td>
                <td class="value" valign="top" nowrap>
                  <esrcore:displayDate name="currentEGTSetting" dateProperty="processStatistic.processEndDate" displayTime="true" nullText=""/>
                </td>
              </tr>
              </tbody>
            </table>
        </td>
      </tr>
	 </auth:authorize>
    </table>
  </td>
</tr>
</table>

<br>

<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell">
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
     <auth:authorize ifAnyGranted="<%=Capability.VIEW_FUTUTRE_EGT_SETTINGS.getName()%>">
      <%-- Future Enrollment Group Threshold Setting Section --%>
      <tr>
        <td>
          <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
            <tr>
              <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
              <td nowrap style="padding-left: 7"><bean-el:message key="label.egt.futureEGTSettingHeader"/></td>
              <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
            <auth:authorize ifAnyGranted="<%=Capability.ADD_EGT_SETTINGS.getName()%>">
              <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                <fw:link action="/addEGTSetting?methodName=DISPLAY"><bean-el:message key="button.egt.addNewEGTSetting"/></fw:link>
              </td>
            </auth:authorize>
            </tr>
          </table>
        </td>
      </tr>
      <c:choose>
      <c:when test="${vlhlist.valueListInfo.totalNumberOfEntries == 0}">
      <tr>
        <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
      </tr>
      </c:when>
      <c:otherwise>
      <tr width="100%">
        <td vAlign="top" align="center">
          <div id="futureEGTSettings" style="border-width:0px;">
            <table id="egtTableResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable">
              <vlh:root id="futureEGTSettingsTableId" value="vlhlist" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
              <vlh:addParam name="checkboxName" value="Select" temp="false"/>
              <tr>
                <td colspan="5">
                  <table class="pagelinks">
                    <tr>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                        <td width="5%" nowrap="true">
                          <span class="pagebanner"><c:out value="${vlhlist.valueListInfo.totalNumberOfEntries}"/> Total
                          - Page (<c:out value="${vlhlist.valueListInfo.pagingPage}"/> of <c:out value="${vlhlist.valueListInfo.totalNumberOfPages}"/>).
                          &nbsp;</span>
                        </td>
                        <td width="5%">
                      <c:choose>
                      <c:when test="${vlhlist.valueListInfo.totalNumberOfPages > 1}">
                        <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pagefutureEGTSettingsTableId}"/>&nbsp;</vlh:paging>
                      </c:when>
                      <c:otherwise>
                        &nbsp;
                      </c:otherwise>
                      </c:choose>
                    </td>
                      <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              <tr vAlign="top">
                <td vAlign="top" align="center">
                  <table summary="List of EGT Settings" rules="all" class="TableDisplay">
                    <tr>
                      <vlh:row bean="egtSetting">
                        <vlh:column title="EGT Effective Date" property="effectiveDate" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'" default="">
                          <vlh:attribute name="scope">row</vlh:attribute>
                          <a <auth:authorize ifAnyGranted="<%=Capability.EDIT_EGT_SETTINGS.getName()%>">
							               href="/esr/egt/updateEGTSetting.do?methodName=DISPLAY&amp;egtSettingId=<c:out value="${egtSetting.entityKey.keyValue}"/>"
                             </auth:authorize>>
							            <esrcore:displayDate name="egtSetting" dateProperty="effectiveDate" displayTime="false" nullText=""/></a>
                        </vlh:column>

                        <vlh:column title="EGT Type" property="type" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'" default="">
                          <esrcore:displayValue name="egtSetting" property="type" nullText=""/>
                        </vlh:column>

                        <vlh:column title="EGT Priority" property="priorityGroup.code" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'" default="">
                          <esrcore:displayValue name="egtSetting" property="priorityGroup.code" nullText=""/><esrcore:displayLookupValue name="egtSetting" property="prioritySubGroup.code" lookupType="gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup" lookupProperty="description"/>
                        </vlh:column>

                        <vlh:column title="Federal Register Date" property="federalRegisterDate" sortable="asc" attributes="class='valuelistRow1' align=\"left\" scope='col'" default="">
                          <esrcore:displayDate name="egtSetting" dateProperty="federalRegisterDate" displayTime="false" nullText=""/>
                        </vlh:column>
                      </vlh:row>
                    </tr>
                  </table>
                </td>
              </tr>
              </vlh:root>
            </table>
          </div>
        </td>
      </tr>
      </c:otherwise>
      </c:choose>
	 </auth:authorize>
    </table>
  </td>
</tr>
</html-el:form>
</table>
