<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el"%>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>
<%@ taglib uri="/tags/displaytag" prefix="display" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/valuelist" prefix="vlh" %>
<%@ taglib uri="/tags/fw" prefix="fw"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>




<c:set var="displayHandbookLink" value="false"/>
<auth:authorize ifAnyGranted="<%=Capability.VIEW_HANDBOOK.getName()%>">
  <c:set var="displayHandbookLink" value="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.VIEW_BENEFITS_AT_A_GLANCE.getName()%>">
  <c:set var="displayAtAGlanceLink" value="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.REPUBLISH_HANDBOOK.getName()%>">
  <c:set var="hasRepublishPermission" value="true"/>
</auth:authorize>


<c:if test="${hasRepublishPermission == true}">
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell">
<tr>
<td>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
      <tr>
        <td class="moduleBlueBox">&nbsp;</td>
        <td width="80%" class="moduleHeadline">Mail Handbook</td>
        <td width="18%" class="moduleHeadline">&nbsp;</td>
      </tr>
    </table>
  </td>
</tr>
<tr>
  <td>
    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
          <tr valign="top">
            <td valign="top" align="center">
              <div id="handbookMail" style="border-width:0px;">
                <table id="handbookMailResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                  <vlh:root id="handbookTemplateTableId" value="vlhlistHandbook" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                    <vlh:addParam name="checkboxName" value="Select" temp="false"/>
                    <tr vAlign="top">
                      <td vAlign="top" align="center">
                        <table summary="List of Available Hand Books to Mail" rules="all" class="TableDisplay">
                          <tr>
                            <vlh:row bean="commsTemplate">

                              <vlh:column titleKey="table.communicationName" property="templateName" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                              	<vlh:attribute name="scope">row</vlh:attribute>
                                <esrcore:displayValue name="commsTemplate" property="commsTemplateName" nullText=""/>
                              </vlh:column>

                              <vlh:column titleKey="table.communicationType" property="templateName" sortable="asc" attributes="align=\"left\" scope='col'" default="">
								<esrcore:displayValue name="commsTemplate" property="commsTemplateFormNumber" nullText=""/>								
                              </vlh:column>

                              <vlh:column titleKey="table.mail" property="templateName" sortable="asc" attributes="align=\"left\" scope='col'" default="">
	                              <c:if test="${commsLogForm.allowHandbookMail == true}">
	                              	<a href="/esr/comms/commslog.do?methodName=mail&handbook=Y&selectedFormNumber=<c:out value="${commsTemplate.commsTemplateFormNumber}"/>">Mail</a>
	                              </c:if>
	                              <c:if test="${commsLogForm.allowHandbookMail == false}">
	                              	<a href="#" onclick="javascript:alert('<bean:write name="commsLogForm" property="formattedHandbookMailValidationErrors" filter="false"/>');">Mail</a>	                              
	                              </c:if>
                              </vlh:column>

							</vlh:row>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </vlh:root>
                </table>
              </div>
            </td>
          </tr>

    </table>
    <!-- module shell table body-->
  </td>
</tr>

</table>
<!-- module shell table  -->
</td>
</tr>
</table>
<br/>
</c:if>


<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell">
<tr>
<td>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
<tr>
  <td>
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
      <tr>
        <td class="moduleBlueBox">&nbsp;</td>
        <td width="80%" class="moduleHeadline">Veterans Health Benefits Handbook Status</td>
        <td width="18%" class="moduleHeadline">&nbsp;</td>
      </tr>
    </table>
  </td>
</tr>
<tr>
  <td>
    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
      <c:choose>
        <c:when test="${vlhlist.valueListInfo.totalNumberOfEntries == 0}">
          <tr>
            <td class="darkValue" style="padding:10 0 10 10; text-align: left"><bean-el:message key="label.noDataAvailable"/></td>
          </tr>
        </c:when>
        <c:otherwise>
          <tr valign="top" width="100%">
            <td vAlign="top" align="center">
              <div id="handbookStatus" style="border-width:0px;">
                <table id="handbookStatusResult" align="center" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleTable" role="presentation">
                  <vlh:root id="handbookTableId" value="vlhlist" url="?" includeParameters="*" configName="valueListConfigBeanLookAndFeel">
                  <vlh:addParam name="checkboxName" value="Select" temp="false"/>
                    <tr>
                      <td colspan="5">
                        <table class="pagelinks">
                          <tr>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                            <td width="5%" nowrap="true">
				                          <span class="pagebanner"><c:out value="${vlhlist.valueListInfo.totalNumberOfEntries}"/> Total
				                          - Page (<c:out value="${vlhlist.valueListInfo.pagingPage}"/> of <c:out value="${vlhlist.valueListInfo.totalNumberOfPages}"/>).
				                          &nbsp;</span>
                            </td>
                            <td width="5%">
                              <c:choose>
                                <c:when test="${vlhlist.valueListInfo.totalNumberOfPages > 1}">
                                  <vlh:paging attributes="class=\"pagelinks\"" pages="10"><c:out value="${pagefutureEGTSettingsTableId}"/>&nbsp;</vlh:paging>
                                </c:when>
                                <c:otherwise>
                                  &nbsp;
                                </c:otherwise>
                              </c:choose>
                            </td>
                            <td width="45%"><img alt=""  src="../images/spacer.gif"></td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <tr vAlign="top">
                      <td vAlign="top" align="center">
                        <table summary="List of Veteran Health Benefits Handbook Status" rules="all" class="TableDisplay">
                          <tr>
                            <c:set var="viewCount" value="0"/>
                           
                            <vlh:row bean="commsLog">
                              <c:set var="showHandbookLink" value="false"/>

							  <c:if test="${commsLog.eligibleForView == true}">
									<c:set var="viewCount" value="${viewCount + 1}"/>
									<c:if test="${viewCount <= 3}">
	                            		<c:set var="showHandbookLink" value="true"/>
									</c:if>								
							  </c:if>	  
							  
				
                             
                              <vlh:column titleKey="table.statusDate" property="handBookMailStatus.modifiedOn" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                              <vlh:attribute name="scope">row</vlh:attribute>
                                <esrcore:displayValue name="commsLog" property="handBookMailStatus.modifiedOn" nullText=""/>
                              </vlh:column>

                              <vlh:column titleKey="table.id" property="id" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                                <esrcore:displayValue name="commsLog" property="id" nullText=""/>
                              </vlh:column>

                              <vlh:column titleKey="table.version" property="handbookVersion" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                                <esrcore:displayValue name="commsLog" property="handbookVersion" nullText=""/>
                              </vlh:column>

                              <vlh:column titleKey="table.status" property="handBookMailStatus.statusType.description" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                                <esrcore:displayValue name="commsLog" property="handBookMailStatus.statusType.description" nullText=""/>
                              </vlh:column>

                              <vlh:column titleKey="table.communicationName" property="templateName" sortable="asc" attributes="align=\"left\" scope='col'" default="">
                                <a href="/esr/comms/commslog.do?methodName=Handbook Communication Detail&selectedCommsLogId=<c:out value="${commsLog.id}"/>">
									<esrcore:displayValue name="commsLog" property="formNumber" nullText=""/> -
									<esrcore:displayValue name="commsLog" property="templateName" nullText=""/>
								</a>
                              </vlh:column>
                              
                                  <c:if test="${displayHandbookLink == true}">
		                              <vlh:column titleKey="table.veteransHandbook" property="id" sortable="asc" attributes="align=\"left\" scope='col'" default="">
		                                <c:if test="${showHandbookLink == true}">
			                                <fw:link action="/commsHandbook.do?methodName=Handbook&ver=${commsLog.id}"
														module="/comms" target="_blank">
														View
											</fw:link>
										</c:if>
		                                <c:if test="${showHandbookLink == false}">
			                                &nbsp;
										</c:if>
		                              </vlh:column>
                              	  </c:if>
                                  <c:if test="${displayAtAGlanceLink == true}">
		                              <vlh:column titleKey="table.veteransProfile" property="id" sortable="asc" attributes="align=\"left\" scope='col'" default="">
		                                <c:if test="${showHandbookLink == true}">
			                                <fw:link action="/commsBenefitsGlance.do?methodName=BenefitGlance&ver=${commsLog.id}"
														module="/comms" target="_blank">
														View
											</fw:link>
										</c:if>
		                                <c:if test="${showHandbookLink == false}">
			                                &nbsp;
										</c:if>
		                              </vlh:column>
		                              <vlh:column titleKey="table.rawData" property="id" sortable="asc" attributes="align=\"left\" scope='col'" default="">
		                                <c:if test="${showHandbookLink == true}">
			                                <fw:link action="/commslog.do?methodName=View Raw Data&ver=${commsLog.id}"
														module="/comms">
														View
											</fw:link>
										</c:if>
		                                <c:if test="${showHandbookLink == false}">
			                                &nbsp;
										</c:if>
		                              </vlh:column>
                              	  </c:if>
								
    
                            </vlh:row>
                          </tr>
                        </table>
                      </td>
                    </tr>
                  </vlh:root>
                </table>
              </div>
            </td>
          </tr>
        </c:otherwise>
      </c:choose>

    </table>
    <!-- module shell table body-->
  </td>
</tr>

</table>
<!-- module shell table  -->
</td>
</tr>
</table>
<!-- module shell -->
