<script language="JavaScript" src="../scripts/ESR-Script.js"></script>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="roleAssigned" scope="page"><bean-el:message key="label.assigned"/></c:set>
<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>

<script language="javascript">
function deleteRoleError()
{
  var errorMessage = "This Role is assigned to a user and can not be deleted.";
  alert(errorMessage);
  return false;
}

function deleteRoleConfirm()
{
  var confirmMessage = "Do you really want to delete this Role?";
  return confirm(confirmMessage);
}

function confirmRoleUpdate()
{
  var message = "This Role is assigned to a user. Do you still want to edit?";
  return confirm(message);
}

function expandAllRoles()
{
  expandCollapseLists("roleList", "roleListImage", "roleListHiddenId", "Set");
  document.getElementById("collapseAllLink").style.display="block";
  document.getElementById("expandAllLink").style.display="none";
  return false;
}

function collapseAllRoles()
{
  expandCollapseLists("roleList", "roleListImage", "roleListHiddenId", "Set");
  document.getElementById("collapseAllLink").style.display="none";
  document.getElementById("expandAllLink").style.display="block";
  return false;
}

</script>

<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell">
  <html:form action="/editRole" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
  <%-- Permissions --%>
  <c:set var="addCode"><%=Capability.ADD_ROLES.getName()%></c:set>
  <c:set var="editCode"><%=Capability.EDIT_ROLES.getName()%></c:set>
  <c:set var="deleteCode"><%=Capability.DELETE_ROLES.getName()%></c:set>
  <c:set var="addPermission" value="false"/>
  <c:set var="editPermission" value="false"/>
  <c:set var="deletePermission" value="false"/>
  <auth:authorize ifAnyGranted="${addCode},${editCode}">
    <c:set var="addPermission" value="true"/>
  </auth:authorize>
  <auth:authorize ifAnyGranted="${editCode}">
    <c:set var="editPermission" value="true"/>
  </auth:authorize>
  <auth:authorize ifAnyGranted="${deleteCode}">
    <c:set var="deletePermission" value="true"/>
  </auth:authorize>
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
              <tr>
                <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
                <td nowrap class="moduleHeadline"><bean-el:message key="label.roles"/></td>
                <td width="90%"><img alt=""  src="../images/spacer.gif"/></td>
                <c:if test="${addPermission}">
                <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:60; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.addRole"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                </c:if>
                <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                  <div id="expandAllLink" style="display:block">
                    <fw:link onclick="return(expandAllRoles());return false" action="none">EXPAND ALL</fw:link>
                  </div>
                  <div id="collapseAllLink" style="display:none">
                    <fw:link onclick="return(collapseAllRoles());return false" action="none">COLLAPSE ALL</fw:link>
                  </div>
                </td>
              </tr>
            </table>
          </td>
        </tr>
 <!--CCR13054 - 508- The user is unable to use table commands after the link is expanded on the data table on the Roles tab- Adding Sumamry for navigation help
 					Commenting out internal nested tables and adding formatting to <div> tag to maintain the same UI -->
        <tr>
          <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
              <tr>
                <td style="padding:10 10 10 10">
                  <table summary="List of Roles and Their Capability Sets and Capabilities. 
          		  	Use Enter or Space Bar, to expand a link. Continue using table commands to read the next row within expanded link. Within the expanded link, use the up and down arrow keys to read line by line.
					To return to the expanded link, use the up arrow keys and collapse the link by using Enter or Space Bar. To return to the first level/main expandable link use table commands and then collapse it.
                    Continue using normal table commands to read the rest of the table."
					width="100%" border="0" cellspacing="0" cellpadding="0">
                  <c:set var="rowColor" value="darkValue" />
                    <thead>
                    <tr>
                      <th scope="col" width="38%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><bean-el:message key="label.name"/></b></th>
                      <th scope="col" width="10%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><bean-el:message key="label.activeDate"/></b></th>
                      <th scope="col" width="12%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><bean-el:message key="label.inactivedate"/></b></th>
                      <th scope="col" width="10%" class="darkValue" valign="bottom" nowrap style="text-align: center;padding:5 5 5 5"><b><bean-el:message key="label.assigned"/></b></th>
                      <th scope="col" width="8%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><img role="presentation" alt="edit" src="../images/spacer.gif" width="1" height="1" /></b></th>
                      <th scope="col" width="10%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><img role="presentation" alt="delete" src="../images/spacer.gif" width="1" height="1" /></b></th>
                      <th scope="col" width="12%" class="darkValue" valign="bottom" wrap style="padding:5 5 5 5"><b><img role="presentation" alt="history" src="../images/spacer.gif" width="1" height="1" /></b></th>
                    </tr>
                    </thead>

                    <c:if test="${not empty Roles}">
                    <tbody>
                    <c:forEach var="role" items="${Roles}" varStatus="status">
                    <c:set var="roleId" value="${role.entityKey.keyValue}"/>
                    <c:set var="counter" value="${status.count - 1}" />
                    <c:set var="assigned" value="${role.assigned}"/>
                    <tr>
                      <td scope="row" width="38%" nowrap style="text-align: left;padding:5 5 5 5" class="moduleLabel">
                        <fw:link href="." onclick="expandOrCollapse(roleList${counter}, roleListImage${counter}, roleListHiddenId${counter}); return false">
                          <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="roleListImage${counter}" src="../images/redArrowRight.gif"/><c:out value="${role.name}"/>
                        </fw:link>
                        <input name="roleListHiddenId<c:out value="${counter}"/>" id="roleListHiddenId<c:out value="${counter}"/>" type="hidden" value="false"/>
                      </td>
                      <td nowrap width="10%" style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                        <esrcore:displayDate name="role" dateProperty="activeDate" displayTime="false" nullText=""/>
                      </td>
                      <td nowrap width="12%" style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                        <esrcore:displayDate name="role" dateProperty="inactiveDate" displayTime="false" nullText=""/>
                      </td>
                      <td width="10%" style="padding:5 5 5 5;text-align: center">
                        <c:if test="${assigned}"><html-el:img alt="${roleAssigned}"  src="../images/check_green.gif"/></c:if>
                      </td>
                      <td nowrap width="8%" style="text-align: center;font-size:10pt">
                        <c:if test="${editPermission}">
                        <c:if test="${not assigned}">
                          <fw:link action="editRole.do?methodName=EDIT" paramId="roleId" paramName="roleId">
                            <bean-el:message key="button.edit"/>
                          </fw:link>
                        </c:if>
                        <c:if test="${assigned}">
                          <fw:link onclick="return(confirmRoleUpdate()); return false" action="editRole.do?methodName=EDIT" paramId="roleId" paramName="roleId">
                            <bean-el:message key="button.edit"/>
                          </fw:link>
                        </c:if>
                        </c:if>
                      </td>
                      <td nowrap width="10%" style="text-align: center;font-size:10pt">
                                    <c:if test="${deletePermission}">
                        <c:if test="${assigned}">
                          <fw:link onclick="deleteRoleError(); return false" action="editRole.do?methodName=DELETE" paramId="roleId" paramName="roleId">
                            <bean-el:message key="button.delete"/>
                          </fw:link>
                        </c:if>
                        <c:if test="${not assigned}">
                          <fw:link onclick="return(deleteRoleConfirm()); return false" action="editRole.do?methodName=DELETE" paramId="roleId" paramName="roleId">
                            <bean-el:message key="button.delete"/>
                          </fw:link>
                        </c:if>
                        </c:if>
                      </td>
                      <td nowrap width="12%" style="text-align: center;font-size:10pt">
                        <fw:link action="/viewRoleHistory?methodName=DISPLAY&amp;history=viewHistoricalRole" paramId="entityId" paramName="role" paramProperty="entityKey.keyValue">
                          <bean-el:message key="button.history"/>
                        </fw:link>
                      </td>
                    </tr>

                    <!-- List of Capability Sets and Capabilities -->
                    <tr>
                      <td colspan="7">
                        <div id="<c:out value="roleList${counter}"/>" class="expandCollapseBody" style= "font-family: Verdana, Arial, Helvetica, sans-serif;
							font-size: 11px;
							font-weight: normal;
							color: #000000;text-align: left;margin:5px 0px 0px 25px;">
                        <!-- <table summary="List of Capability Sets and Capabilities for the Selected Role"> -->
                          <%-- Capability Sets --%>
                          <c:forEach var="capabilitySet" items="${role.capabilitySets}" varStatus="setStatus">
                          <c:set var="setCounter" value="${setStatus.count - 1}" />
                          <!--<tr>
                            <td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">&nbsp;</td>

                            <td scope="row" width="40%" nowrap style="text-align: left;padding:5 5 5 5" class="moduleLabel"> -->
                              <fw:link href="." onclick="expandOrCollapse(roleList${counter}Set${setCounter}, roleListImage${counter}Set${setCounter}, roleListHiddenId${counter}Set${setCounter}); return false">
                                <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="roleListImage${counter}Set${setCounter}" src="../images/redArrowRight.gif"/><c:out value="${capabilitySet.name}"/>
                              </fw:link><br/>
                              <input name="roleListHiddenId<c:out value="${counter}Set${setCounter}"/>" id="roleListHiddenId<c:out value="${counter}Set${setCounter}"/>" type="hidden" value="false"/>
                            <!--</td>
                            <td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
                          </tr> -->
                          <%-- CapabilitySet capabilities --%>
                          <!--<tr>
                            <td style="padding:5 5 5 30" colspan="3"> -->
                            <div id="<c:out value="roleList${counter}Set${setCounter}"/>" class="expandCollapseBody" style="text-align: left;margin:5px 0px 0px 18px;">
                              <!--<table summary="List of Capabilities under the Selected Capability Set"> -->
                                <c:forEach var="capability" items="${capabilitySet.capabilities}" varStatus="status">
                                <!--<tr>
                                  <td scope="row" nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>"> -->
                                    <c:out value="${capability.name}"/> <br/><br/>
                                 <!-- </td>
                                  <td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
                                </tr> -->
                                </c:forEach>
                              <!-- </table> -->
                            </div>
                            <!-- </td>
                          </tr> -->
                          </c:forEach>

                          <%-- Capabilities --%>
                          <c:forEach var="capability" items="${role.capabilities}" varStatus="status">
                          <!-- <tr>
                            <td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                              &nbsp;
                            </td>
                            <td scope="row" nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>"> -->
                              <c:out value="${capability.name}"/> <br/><br/>
                            <!-- </td>
                            <td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
                          </tr> -->
                          </c:forEach>
                        <!-- </table> -->
                        </div>
                      </td>
                    </tr>
                    </c:forEach>
                    </tbody>
                    </c:if>
                  </table>
                </td>
              </tr>


              <%-- Deleted Roles --%>
              <c:if test="${not empty DeletedRoles}">
              <tr>
                <td>
                  <table summary="Table for Deleted Roles" width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
                    <tr>
                      <td class="moduleBrownBox"><img alt="" src="../images/spacer.gif" width="29" height="1"/></td>
                      <td>&nbsp;</td>
                      <td class="moduleLabel" nowrap>
                        <fw:link href="." onclick="expandOrCollapse(deletedRolesBlock, deletedRolesImage, deletedRolesHiddenId); return false">
                          <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="deletedRolesImage" src="../images/redArrowRight.gif"/><bean-el:message key="label.deletedRoles"/>
                        </fw:link>
                        <input name="deletedRolesHiddenId" id="deletedRolesHiddenId" type="hidden" value="false"/>
                      </td>
                      <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              </c:if>

              <tr>
                <td style="padding:5 10 10 10">
                  <%-- Deleted Roles Block --%>
                  <c:if test="${not empty DeletedRoles}">
                  <table summary="Table for Details of Deleted Roles" width="100%" border="0" cellspacing="0" cellpadding="0" id="deletedRolesBlock" style="display:none" role="presentation">
                    <tr>
                      <td width="38%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td width="10%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td width="12%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td width="10%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td width="8%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td width="10%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td width="12%"><img alt=""  src="../images/spacer.gif"/></td>
                    </tr>
                    <c:forEach var="role" items="${DeletedRoles}" varStatus="status">
                    <c:set var="roleId" value="${role.entityKey.keyValue}"/>
                    <c:set var="counter" value="${status.count - 1}" />
                    <tr>
                      <td scope="row" nowrap width="38%" style="text-align: left;padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                        <c:out value="${role.name}"/>
                      </td>
                      <td nowrap width="10%" style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                        <esrcore:displayDate name="role" dateProperty="activeDate" displayTime="false" nullText=""/>
                      </td>
                      <td nowrap width="12%" style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                        <esrcore:displayDate name="role" dateProperty="inactiveDate" displayTime="false" nullText=""/>
                      </td>
                      <td width="10%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td width="8%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td width="10%"><img alt=""  src="../images/spacer.gif"/></td>
                      <td nowrap width="12%" style="text-align: center;font-size:10pt">
                        <fw:link action="/viewRoleHistory?methodName=DISPLAY&amp;history=viewHistoricalRole"
                          paramId="entityId" paramName="role" paramProperty="entityKey.keyValue">
                          <bean-el:message key="button.history"/>
                        </fw:link>
                      </td>
                    </tr>
                    </c:forEach>
                  </table>
                  </c:if>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  </html:form>
</table>
